/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.ami;

import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;

public class AICcComparator<M extends IArimaModel> {
    private final double aicDiff_;

    public AICcComparator(double aiccDiff) {
        this.aicDiff_ = aiccDiff;
    }

    public int compare(RegArimaEstimation<M> reference, RegArimaEstimation<M>[] models) {
        int imin = -1;
        double aicc = 0.0;
        for (int i = 0; i < models.length; ++i) {
            if (models[i] == null) continue;
            double aiccCur = models[i].statistics().getAICC();
            if (imin >= 0 && !(aiccCur < aicc)) continue;
            aicc = aiccCur;
            imin = i;
        }
        if (imin < 0) {
            return -1;
        }
        if (reference == null) {
            return imin;
        }
        double aiccRef = reference.statistics().getAICC();
        return aiccRef > aicc - this.aicDiff_ ? imin : -1;
    }

    public int compare(RegArimaEstimation<M> reference, RegArimaEstimation<M> alternative) {
        double aicc;
        if (reference == null) {
            return 0;
        }
        if (alternative == null) {
            return -1;
        }
        double aiccRef = reference.statistics().getAICC();
        return aiccRef > (aicc = alternative.statistics().getAICC()) - this.aicDiff_ ? 0 : -1;
    }
}

