/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.dk;

import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfState;
import jdplus.toolkit.base.core.ssf.State;

public class DiffuseState
extends State {
    private final FastMatrix Pi;

    public static DiffuseState of(ISsfState ssf) {
        ISsfInitialization initialization = ssf.initialization();
        DiffuseState state = new DiffuseState(initialization.getStateDim());
        initialization.a0(state.a());
        initialization.Pf0(state.P());
        if (initialization.isDiffuse()) {
            initialization.Pi0(state.Pi);
        }
        return state;
    }

    public DiffuseState(int dim) {
        super(dim);
        this.Pi = FastMatrix.square(dim);
    }

    public FastMatrix Pi() {
        return this.Pi;
    }

    public boolean isDiffuse() {
        return this.Pi.isZero(1.0E-9);
    }

    @Override
    public void next(int pos, ISsfDynamics dynamics) {
        super.next(pos, dynamics);
        dynamics.TVT(pos, this.Pi);
    }
}

