/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.producer.ConsoleProducer;
import kafka.producer.ConsoleProducer$;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.serializer.StringEncoder;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConsoleProducer$
implements ScalaObject {
    public static final ConsoleProducer$ MODULE$;

    static {
        new ConsoleProducer$();
    }

    public void main(String[] args) {
        OptionParser parser$1 = new OptionParser();
        ArgumentAcceptingOptionSpec<String> topicOpt = parser$1.accepts("topic", "REQUIRED: The topic id to produce messages to.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> brokerListOpt = parser$1.accepts("broker-list", "REQUIRED: The broker list string in the form HOST1:PORT1,HOST2:PORT2.").withRequiredArg().describedAs("broker-list").ofType(String.class);
        OptionSpecBuilder syncOpt = parser$1.accepts("sync", "If set message send requests to the brokers are synchronously, one at a time as they arrive.");
        OptionSpecBuilder compressOpt = parser$1.accepts("compress", "If set, messages batches are sent compressed");
        ArgumentAcceptingOptionSpec<Integer> batchSizeOpt = parser$1.accepts("batch-size", "Number of messages to send in a single batch if they are not being sent synchronously.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(200), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<Integer> messageSendMaxRetriesOpt = parser$1.accepts("message-send-max-retries", "Brokers can fail receiving the message for multiple reasons, and being unavailable transiently is just one of them. This property specifies the number of retires before the producer give up and drop this message.").withRequiredArg().ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(3), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<Long> retryBackoffMsOpt = parser$1.accepts("retry-backoff-ms", "Before each retry, the producer refreshes the metadata of relevant topics. Since leader election takes a bit of time, this property specifies the amount of time that the producer waits before refreshing the metadata.").withRequiredArg().ofType(Long.class).defaultsTo(Predef$.MODULE$.long2Long(100L), (Long[])((Object[])new Long[0]));
        ArgumentAcceptingOptionSpec<Long> sendTimeoutOpt = parser$1.accepts("timeout", "If set and the producer is running in asynchronous mode, this gives the maximum amount of time a message will queue awaiting suffient batch size. The value is given in ms.").withRequiredArg().describedAs("timeout_ms").ofType(Long.class).defaultsTo(Predef$.MODULE$.long2Long(1000L), (Long[])((Object[])new Long[0]));
        ArgumentAcceptingOptionSpec<Long> queueSizeOpt = parser$1.accepts("queue-size", "If set and the producer is running in asynchronous mode, this gives the maximum amount of  messages will queue awaiting suffient batch size.").withRequiredArg().describedAs("queue_size").ofType(Long.class).defaultsTo(Predef$.MODULE$.long2Long(10000L), (Long[])((Object[])new Long[0]));
        ArgumentAcceptingOptionSpec<Long> queueEnqueueTimeoutMsOpt = parser$1.accepts("queue-enqueuetimeout-ms", "Timeout for event enqueue").withRequiredArg().describedAs("queue enqueuetimeout ms").ofType(Long.class).defaultsTo(Predef$.MODULE$.long2Long(Integer.MAX_VALUE), (Long[])((Object[])new Long[0]));
        ArgumentAcceptingOptionSpec<Integer> requestRequiredAcksOpt = parser$1.accepts("request-required-acks", "The required acks of the producer requests").withRequiredArg().describedAs("request required acks").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(0), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<Integer> requestTimeoutMsOpt = parser$1.accepts("request-timeout-ms", "The ack timeout of the producer requests. Value must be non-negative and non-zero").withRequiredArg().describedAs("request timeout ms").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1500), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<String> valueEncoderOpt = parser$1.accepts("value-serializer", "The class name of the message encoder implementation to use for serializing values.").withRequiredArg().describedAs("encoder_class").ofType(String.class).defaultsTo(StringEncoder.class.getName(), (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<String> keyEncoderOpt = parser$1.accepts("key-serializer", "The class name of the message encoder implementation to use for serializing keys.").withRequiredArg().describedAs("encoder_class").ofType(String.class).defaultsTo(StringEncoder.class.getName(), (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<String> messageReaderOpt = parser$1.accepts("line-reader", "The class name of the class to use for reading lines from standard in. By default each line is read as a separate message.").withRequiredArg().describedAs("reader_class").ofType(String.class).defaultsTo(ConsoleProducer.LineMessageReader.class.getName(), (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt = parser$1.accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(102400), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<String> propertyOpt = parser$1.accepts("property", "A mechanism to pass user-defined properties in the form key=value to the message reader. This allows custom configuration for a user-defined message reader.").withRequiredArg().describedAs("prop").ofType(String.class);
        OptionSet options$1 = parser$1.parse(args);
        List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{topicOpt, brokerListOpt})).foreach(new anonfun.main.1(parser$1, options$1));
        String topic = options$1.valueOf(topicOpt);
        String brokerList = options$1.valueOf(brokerListOpt);
        boolean sync = options$1.has(syncOpt);
        boolean compress = options$1.has(compressOpt);
        Integer batchSize = options$1.valueOf(batchSizeOpt);
        Long sendTimeout = options$1.valueOf(sendTimeoutOpt);
        Long queueSize = options$1.valueOf(queueSizeOpt);
        Long queueEnqueueTimeoutMs = options$1.valueOf(queueEnqueueTimeoutMsOpt);
        Integer requestRequiredAcks = options$1.valueOf(requestRequiredAcksOpt);
        Integer requestTimeoutMs = options$1.valueOf(requestTimeoutMsOpt);
        String keyEncoderClass = options$1.valueOf(keyEncoderOpt);
        String valueEncoderClass = options$1.valueOf(valueEncoderOpt);
        String readerClass = options$1.valueOf(messageReaderOpt);
        Integer socketBuffer = options$1.valueOf(socketBufferSizeOpt);
        Properties cmdLineProps = this.parseLineReaderArgs(JavaConversions$.MODULE$.asBuffer(options$1.valuesOf(propertyOpt)));
        cmdLineProps.put("topic", topic);
        Properties props = new Properties();
        props.put("metadata.broker.list", brokerList);
        int codec = compress ? DefaultCompressionCodec$.MODULE$.codec() : NoCompressionCodec$.MODULE$.codec();
        props.put("compression.codec", ((Object)BoxesRunTime.boxToInteger(codec)).toString());
        props.put("producer.type", sync ? "sync" : "async");
        Object object = options$1.has(batchSizeOpt) ? props.put("batch.num.messages", batchSize.toString()) : BoxedUnit.UNIT;
        props.put("message.send.max.retries", options$1.valueOf(messageSendMaxRetriesOpt).toString());
        props.put("retry.backoff.ms", options$1.valueOf(retryBackoffMsOpt).toString());
        props.put("queue.buffering.max.ms", sendTimeout.toString());
        props.put("queue.buffering.max.messages", queueSize.toString());
        props.put("queue.enqueue.timeout.ms", queueEnqueueTimeoutMs.toString());
        props.put("request.required.acks", requestRequiredAcks.toString());
        props.put("request.timeout.ms", requestTimeoutMs.toString());
        props.put("key.serializer.class", keyEncoderClass);
        props.put("serializer.class", valueEncoderClass);
        props.put("send.buffer.bytes", socketBuffer.toString());
        ConsoleProducer.MessageReader reader = (ConsoleProducer.MessageReader)Class.forName(readerClass).newInstance();
        reader.init(System.in, cmdLineProps);
        try {
            Producer producer$1 = new Producer(new ProducerConfig(props));
            Runtime.getRuntime().addShutdownHook(new anon.1(producer$1));
            KeyedMessage message = null;
            while (true) {
                if ((message = reader.readMessage()) != null) {
                    producer$1.send(Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{message}));
                }
                if (message != null) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseLineReaderArgs(Iterable<String> args) {
        void var3_3;
        Iterable splits = (Iterable)((TraversableLike)((TraversableLike)args.map(new anonfun.1(), Iterable$.MODULE$.canBuildFrom())).filterNot(new anonfun.2())).filterNot(new anonfun.3());
        if (!splits.forall(new anonfun.parseLineReaderArgs.1())) {
            System.err.println(new StringBuilder().append((Object)"Invalid line reader properties: ").append((Object)args.mkString(" ")).toString());
            System.exit(1);
        }
        Properties props$1 = new Properties();
        splits.foreach(new anonfun.parseLineReaderArgs.2(props$1));
        return var3_3;
    }

    private ConsoleProducer$() {
        MODULE$ = this;
    }
}

