/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaiimageio.jpeg2000.impl;

import com.github.jaiimageio.impl.common.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;

public class MediaLibAccessor {
    private static final int COPY_MASK_SHIFT = 7;
    private static final int COPY_MASK_SIZE = 1;
    public static final int COPY_MASK = 128;
    public static final int UNCOPIED = 0;
    public static final int COPIED = 128;
    public static final int DATATYPE_MASK = 127;
    private static final int BINARY_MASK_SHIFT = 8;
    private static final int BINARY_MASK_SIZE = 1;
    public static final int BINARY_MASK = 256;
    public static final int NONBINARY = 0;
    public static final int BINARY = 256;
    public static final int TAG_BYTE_UNCOPIED = 0;
    public static final int TAG_USHORT_UNCOPIED = 1;
    public static final int TAG_SHORT_UNCOPIED = 2;
    public static final int TAG_INT_UNCOPIED = 3;
    public static final int TAG_FLOAT_UNCOPIED = 4;
    public static final int TAG_DOUBLE_UNCOPIED = 5;
    public static final int TAG_BYTE_COPIED = 128;
    public static final int TAG_USHORT_COPIED = 129;
    public static final int TAG_SHORT_COPIED = 130;
    public static final int TAG_INT_COPIED = 131;
    public static final int TAG_FLOAT_COPIED = 132;
    public static final int TAG_DOUBLE_COPIED = 133;
    protected Raster raster;
    protected Rectangle rect;
    protected int numBands;
    protected int[] bandOffsets;
    protected int formatTag;
    private boolean areBinaryDataPacked = false;

    public static int findCompatibleTag(Raster src) {
        SampleModel dstSM = src.getSampleModel();
        int dstDT = dstSM.getDataType();
        int defaultDataType = dstSM.getDataType();
        boolean allComponentSampleModel = dstSM instanceof ComponentSampleModel;
        boolean allBinary = ImageUtil.isBinary(dstSM);
        if (allBinary) {
            return 256;
        }
        if (!(allComponentSampleModel || defaultDataType != 0 && defaultDataType != 1 && defaultDataType != 2)) {
            defaultDataType = 3;
        }
        int tag = defaultDataType | 0x80;
        if (!allComponentSampleModel) {
            return tag;
        }
        if (MediaLibAccessor.isPixelSequential(dstSM)) {
            return dstDT | 0;
        }
        return tag;
    }

    public static boolean isPixelSequential(SampleModel sm) {
        ComponentSampleModel csm = null;
        if (!(sm instanceof ComponentSampleModel)) {
            return false;
        }
        csm = (ComponentSampleModel)sm;
        int pixelStride = csm.getPixelStride();
        int[] bandOffsets = csm.getBandOffsets();
        int[] bankIndices = csm.getBankIndices();
        if (pixelStride != bandOffsets.length) {
            return false;
        }
        if (pixelStride != sm.getNumBands()) {
            return false;
        }
        for (int i = 0; i < bandOffsets.length; ++i) {
            if (bandOffsets[i] >= pixelStride || bankIndices[i] != bankIndices[0]) {
                return false;
            }
            for (int j = i + 1; j < bandOffsets.length; ++j) {
                if (bandOffsets[i] == bandOffsets[j]) {
                    return false;
                }
                if (bandOffsets[i] == i) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isBinary() {
        return (this.formatTag & 0x100) == 256;
    }

    public int getDataType() {
        return this.formatTag & 0x7F;
    }

    public boolean isDataCopy() {
        return (this.formatTag & 0x80) == 128;
    }

    public int[] getBandOffsets() {
        return this.bandOffsets;
    }

    public int[] getIntParameters(int band, int[] params) {
        int[] returnParams = new int[this.numBands];
        for (int i = 0; i < this.numBands; ++i) {
            returnParams[i] = params[this.bandOffsets[i + band]];
        }
        return returnParams;
    }

    public int[][] getIntArrayParameters(int band, int[][] params) {
        int[][] returnParams = new int[this.numBands][];
        for (int i = 0; i < this.numBands; ++i) {
            returnParams[i] = params[this.bandOffsets[i + band]];
        }
        return returnParams;
    }

    public double[] getDoubleParameters(int band, double[] params) {
        double[] returnParams = new double[this.numBands];
        for (int i = 0; i < this.numBands; ++i) {
            returnParams[i] = params[this.bandOffsets[i + band]];
        }
        return returnParams;
    }

    private int[] toIntArray(double[] vals) {
        int[] returnVals = new int[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            returnVals[i] = (int)vals[i];
        }
        return returnVals;
    }

    private float[] toFloatArray(double[] vals) {
        float[] returnVals = new float[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            returnVals[i] = (float)vals[i];
        }
        return returnVals;
    }
}

