% Generated by roxygen2: do not edit by hand
\name{barplot}
\alias{barplot}
\title{Create Bar Plots from a Contingency Table}
\arguments{
  \item{height}{a vector or matrix of values to be plotted as bars}
  \item{space}{space between adjacent bars}
  \item{horiz}{logical; should the bars be displayed horizontally?}
  \item{beside}{logical; plot grouped bars side-by-side?}
  \item{...}{\{.help [graphical parameters](graphics::par)\}, e.g. `col`
}
}

\details{
Create basic barplots from a table
\code{
(counts <- xtabs(~ cyl, data = mtcars))
barplot(counts)
barplot(counts, space = 3)
barplot(counts, horiz = TRUE, col = "steelblue")
}

Create stacked barplots from a 2d contingency table
\code{
counts <- xtabs(~ cyl + gear, data = mtcars)
cols <- c("firebrick", "gray80", "steelblue")
barplot(counts, col = cols, xlab = "gear")
}

Create side-by-side barplots from a 2d contingency table
\code{
barplot(counts, col = cols, xlab = "gear", beside = TRUE)
legend("topright", legend = c("6","4","8"), fill = cols,
       title = "cyl", horiz = TRUE)
}}

