% Generated by roxygen2: do not edit by hand
\name{rbind}
\alias{rbind}
\alias{cbind}
\title{Combine R Objects by Rows or Columns}
\arguments{
  \item{...}{vectors, matrices, or data frames to bind together
}
}

\details{
Combine vectors into a matrix
\code{
x <- 1:3
y <- 4:6
rbind(x, y)  # combine vectors by row
cbind(x, y)  # combine vectors by column
}

Combine matrices by rows and columns
\code{
(A <- matrix(1:4, nrow = 2))
(B <- matrix(5:8, nrow = 2))
rbind(A, B)  # combine matrices by row
cbind(A, B)  # combine matrices by column
}

Combine data frames by rows and columns
\code{
df1 <- data.frame(a = 1:3, b = 4:6)
df2 <- data.frame(a = 7:9, b = 5:7)
rbind(df1, df2)  # combine data frames by row

df3 <- data.frame(c = 7:9, d = 10:12)
cbind(df1, df3)  # combine data frames by column
}}

