$PROBLEM Simulated PKPD
$INPUT ID TIME DOSE AMT CMT EVID DV MDV 
	  BLQ CL VC Q VP KA LLOQ
$DATA sim.csv IGNORE=@
$SUBROUTINE ADVAN13 TOL=9
$MODEL NCOMPARTMENTS=4

$PK
TVBASE = THETA(1)
MU_1 = LOG(TVBASE)
BASE = EXP(MU_1 + ETA(1))
TVKDEG = THETA(2)/24
MU_2 = LOG(TVKDEG)
KDEG = EXP(MU_2 + ETA(2))
KSYN = BASE*KDEG
IMAX = 1/(1 + 1/EXP(THETA(3)))
IC50 = THETA(4)/1000
RUV = THETA(5)

A_0(4) = BASE

$DES
DADT(1) = -KA*A(1)
DADT(2) = KA*A(1) - A(2)*CL/VC + Q*(A(3)/VP - A(2)/VC)
DADT(3) = Q*(A(2)/VC - A(3)/VP)

CONC = A(2)/VC
EFF = 1 - IMAX*CONC/(IC50 + CONC)

DADT(4) = KSYN*EFF - A(4)*KDEG

$ERROR

IPRE = A(4)
W = RUV*IPRE
IRES = DV - IPRE
IWRES = IRES/W
LIKE = PHI((LLOQ - IPRE)/W) + 1e-04
IF (BLQ.EQ.1) THEN
	MDVRES = 1
	Y = LIKE
	F_FLAG = 1
ENDIF
IF (BLQ.EQ.0) THEN
	Y = IPRE + EPS(1) * W
	F_FLAG = 0
ENDIF

$THETA
(0, 150) ; BASE
(0, 0.1) ; KDEG
1.5 ; IMAX
(0, 850) ; IC50
(0, 0.8) ; RUV

$OMEGA
0.6 ; IIVBASE
0.2 ; IIVKDEG

$SIGMA
1 FIX


$ESTIMATION METHOD = 1 INTER LAPLACE NSIG=3 SIGL=9 NOABORT MAXEVAL = 9999
			PRINT = 1 FILE=run.ext MSFO=pdmod

$COVARIANCE PRINT = E UNCONDITIONAL SIGL=9 MATRIX = S

$TABLE ID AMT DOSE TIME BLQ LLOQ LIKE EVID MDV
	   ETAS(1:LAST) NPDE IPRE IRES IWRES CWRES NOPRINT ONEHEADER
  	   ESAMPLE=1000 FORMAT=s1PE13.7 FILE=output.fit

$TABLE ID BASE KDEG IMAX IC50 CL VC Q VP KA NOPRINT ONEHEADER
  	   FIRSTONLY NOAPPEND FORMAT=s1PE13.7 FILE=pars.fit
