/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;
import umontreal.iro.lecuyer.util.RootFinder;

public class LogarithmicDist
extends DiscreteDistributionInt {
    private double theta;
    private double t;

    public LogarithmicDist(double d) {
        this.setTheta(d);
    }

    public double prob(int n) {
        if (n < 1) {
            return 0.0;
        }
        return this.t * Math.pow(this.theta, n) / (double)n;
    }

    public double cdf(int n) {
        double d;
        if (n < 1) {
            return 0.0;
        }
        double d2 = d = this.prob(1);
        for (int i = 2; i <= n; ++i) {
            d += (d2 *= this.theta) / (double)i;
        }
        return d;
    }

    public double barF(int n) {
        double d;
        if (n <= 1) {
            return 1.0;
        }
        double d2 = d = this.prob(n);
        int n2 = n + 1;
        while (d2 > EPSILON) {
            d += (d2 *= this.theta * (double)(n2 - 1) / (double)n2);
        }
        return d;
    }

    public int inverseFInt(double d) {
        return LogarithmicDist.inverseF(this.theta, d);
    }

    public double getMean() {
        return LogarithmicDist.getMean(this.theta);
    }

    public double getVariance() {
        return LogarithmicDist.getVariance(this.theta);
    }

    public double getStandardDeviation() {
        return LogarithmicDist.getStandardDeviation(this.theta);
    }

    public static double prob(double d, int n) {
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("theta not in range (0,1)");
        }
        if (n < 1) {
            return 0.0;
        }
        return -1.0 / Math.log1p(-d) * Math.pow(d, n) / (double)n;
    }

    public static double cdf(double d, int n) {
        double d2;
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("theta not in range (0,1)");
        }
        if (n < 1) {
            return 0.0;
        }
        double d3 = d2 = LogarithmicDist.prob(d, 1);
        for (int i = 2; i <= n; ++i) {
            d2 += (d3 *= d) / (double)i;
        }
        return d2;
    }

    public static double barF(double d, int n) {
        double d2;
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("theta not in range (0,1)");
        }
        if (n <= 1) {
            return 1.0;
        }
        double d3 = d2 = LogarithmicDist.prob(d, n);
        int n2 = n + 1;
        while (d3 > EPSILON) {
            d2 += (d3 *= d * (double)(n2 - 1) / (double)n2);
        }
        return d2;
    }

    public static int inverseF(double d, double d2) {
        throw new UnsupportedOperationException();
    }

    public static double[] getMLE(int[] nArray, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] dArray = new double[1];
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += (double)nArray[i];
        }
        double d2 = d / (double)n;
        Function function = new Function(d2);
        dArray[0] = RootFinder.brentDekker(1.0E-15, 0.999999999999999, function, 1.0E-7);
        return dArray;
    }

    public static double[] getMaximumLikelihoodEstimate(int[] nArray, int n) {
        return LogarithmicDist.getMLE(nArray, n);
    }

    public static LogarithmicDist getInstanceFromMLE(int[] nArray, int n) {
        double[] dArray = LogarithmicDist.getMaximumLikelihoodEstimate(nArray, n);
        return new LogarithmicDist(dArray[0]);
    }

    public static double getMean(double d) {
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("theta not in range (0,1)");
        }
        return -1.0 / Math.log1p(-d) * (d / (1.0 - d));
    }

    public static double getVariance(double d) {
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("theta not in range (0,1)");
        }
        double d2 = Math.log1p(-d);
        return -d * (d + d2) / ((1.0 - d) * (1.0 - d) * d2 * d2);
    }

    public static double getStandardDeviation(double d) {
        return Math.sqrt(LogarithmicDist.getVariance(d));
    }

    public double getTheta() {
        return this.theta;
    }

    public void setTheta(double d) {
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("theta not in range (0,1)");
        }
        this.theta = d;
        this.t = -1.0 / Math.log1p(-d);
        this.supportA = 1;
    }

    public double[] getParams() {
        double[] dArray = new double[]{this.theta};
        return dArray;
    }

    public String toString() {
        return this.getClass().getName() + " : theta = " + this.theta;
    }

    private static class Function
    implements MathFunction {
        protected double mean;

        public Function(double d) {
            this.mean = d;
        }

        public double evaluate(double d) {
            if (d <= 0.0 || d >= 1.0) {
                return 1.0E200;
            }
            return d + this.mean * (1.0 - d) * Math.log1p(-d);
        }
    }
}

