/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdistmulti;

import umontreal.iro.lecuyer.probdistmulti.DiscreteDistributionIntMulti;
import umontreal.iro.lecuyer.util.Num;

public class MultinomialDist
extends DiscreteDistributionIntMulti {
    protected int n;
    protected double[] p;

    public MultinomialDist(int n, double[] dArray) {
        this.setParams(n, dArray);
    }

    public double prob(int[] nArray) {
        return MultinomialDist.prob_(this.n, this.p, nArray);
    }

    public double cdf(int[] nArray) {
        return MultinomialDist.cdf_(this.n, this.p, nArray);
    }

    public double[] getMean() {
        return MultinomialDist.getMean_(this.n, this.p);
    }

    public double[][] getCovariance() {
        return MultinomialDist.getCovariance_(this.n, this.p);
    }

    public double[][] getCorrelation() {
        return MultinomialDist.getCorrelation_(this.n, this.p);
    }

    private static void verifParam(int n, double[] dArray) {
        double d = 0.0;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] < 0.0 || dArray[i] > 1.0) {
                throw new IllegalArgumentException("p is not a probability vector");
            }
            d += dArray[i];
        }
        if (d != 1.0) {
            throw new IllegalArgumentException("p is not a probability vector");
        }
    }

    private static double prob_(int n, double[] dArray, int[] nArray) {
        double d = 0.0;
        int n2 = 0;
        double d2 = 0.0;
        if (nArray.length != dArray.length) {
            throw new IllegalArgumentException("x and p must have the same dimension");
        }
        for (int i = 0; i < dArray.length; ++i) {
            n2 += nArray[i];
            d += Num.lnFactorial(nArray[i]);
            d2 += (double)nArray[i] * Math.log(dArray[i]);
        }
        if (n2 != n) {
            return 0.0;
        }
        return Math.exp(Num.lnFactorial(n) - d + d2);
    }

    public static double prob(int n, double[] dArray, int[] nArray) {
        MultinomialDist.verifParam(n, dArray);
        return MultinomialDist.prob_(n, dArray, nArray);
    }

    private static double cdf_(int n, double[] dArray, int[] nArray) {
        boolean bl = false;
        double d = 0.0;
        if (nArray.length != dArray.length) {
            throw new IllegalArgumentException("x and p must have the same dimension");
        }
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = 0;
        }
        d = 0.0;
        while (!bl) {
            d += MultinomialDist.prob(n, dArray, nArray2);
            nArray2[0] = nArray2[0] + 1;
            if (nArray2[0] <= nArray[0]) continue;
            nArray2[0] = 0;
            int n2 = 1;
            while (n2 < nArray.length && nArray2[n2] == nArray[n2]) {
                nArray2[n2++] = 0;
            }
            if (n2 == nArray.length) {
                bl = true;
                continue;
            }
            int n3 = n2;
            nArray2[n3] = nArray2[n3] + 1;
        }
        return d;
    }

    public static double cdf(int n, double[] dArray, int[] nArray) {
        MultinomialDist.verifParam(n, dArray);
        return MultinomialDist.cdf_(n, dArray, nArray);
    }

    private static double[] getMean_(int n, double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = (double)n * dArray[i];
        }
        return dArray2;
    }

    public static double[] getMean(int n, double[] dArray) {
        MultinomialDist.verifParam(n, dArray);
        return MultinomialDist.getMean_(n, dArray);
    }

    private static double[][] getCovariance_(int n, double[] dArray) {
        double[][] dArray2 = new double[dArray.length][dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                dArray2[i][j] = (double)(-n) * dArray[i] * dArray[j];
            }
            dArray2[i][i] = (double)n * dArray[i] * (1.0 - dArray[i]);
        }
        return dArray2;
    }

    public static double[][] getCovariance(int n, double[] dArray) {
        MultinomialDist.verifParam(n, dArray);
        return MultinomialDist.getCovariance_(n, dArray);
    }

    private static double[][] getCorrelation_(int n, double[] dArray) {
        double[][] dArray2 = new double[dArray.length][dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                dArray2[i][j] = -Math.sqrt(dArray[i] * dArray[j] / ((1.0 - dArray[i]) * (1.0 - dArray[j])));
            }
            dArray2[i][i] = 1.0;
        }
        return dArray2;
    }

    public static double[][] getCorrelation(int n, double[] dArray) {
        MultinomialDist.verifParam(n, dArray);
        return MultinomialDist.getCorrelation_(n, dArray);
    }

    public static double[] getMaximumLikelihoodEstimate(int[][] nArray, int n, int n2, int n3) {
        int n4;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double d = 0.0;
        if (n <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        for (n4 = 0; n4 < n2; ++n4) {
            dArray2[n4] = 0.0;
        }
        for (n4 = 0; n4 < n; ++n4) {
            for (int i = 0; i < n2; ++i) {
                int n5 = i;
                dArray2[n5] = dArray2[n5] + (double)nArray[n4][i];
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            dArray2[n4] = dArray2[n4] / (double)n3;
            d += dArray2[n4];
        }
        if (d != (double)n3) {
            throw new IllegalArgumentException("n is not correct");
        }
        for (n4 = 0; n4 < n2; ++n4) {
            dArray[n4] = dArray2[n4] / (double)n3;
        }
        return dArray;
    }

    public int getN() {
        return this.n;
    }

    public double[] getP() {
        return this.p;
    }

    public void setParams(int n, double[] dArray) {
        double d = 0.0;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (dArray.length < 2) {
            throw new IllegalArgumentException("p.length < 2");
        }
        this.n = n;
        this.dimension = dArray.length;
        this.p = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            if (dArray[i] < 0.0 || dArray[i] > 1.0) {
                throw new IllegalArgumentException("p is not a probability vector");
            }
            this.p[i] = dArray[i];
            d += dArray[i];
        }
        if (d != 1.0) {
            throw new IllegalArgumentException("p is not a probability vector");
        }
    }
}

