/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit;

import ec.satoolkit.IPreprocessingFilter;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;

public class DefaultPreprocessingFilter
implements IPreprocessingFilter {
    private static final double EPS = 1.0E-8;
    private PreprocessingModel model_;
    @Deprecated
    private double mean_;
    private int nf_ = -2;
    private int nb_ = -2;
    private final boolean noapply;

    public DefaultPreprocessingFilter() {
        this.noapply = false;
    }

    public DefaultPreprocessingFilter(boolean noapply) {
        this.noapply = noapply;
    }

    public int getForecastHorizon() {
        return this.nf_;
    }

    public void setForecastHorizon(int nf) {
        this.nf_ = nf;
    }

    public int getBackcastHorizon() {
        return this.nb_;
    }

    public void setBackcastHorizon(int nb) {
        this.nb_ = nb;
    }

    @Deprecated
    public boolean isSeasonalMeanCorrection() {
        return this.mean_ != 0.0;
    }

    @Override
    public boolean process(PreprocessingModel model) {
        this.model_ = model;
        this.mean_ = this.seasMeanCorrection(model);
        return true;
    }

    @Deprecated
    private double seasMeanCorrection(PreprocessingModel model) {
        if (this.noapply) {
            return 0.0;
        }
        TsDomain domain = model.description.getSeriesDomain();
        int freq = domain.getFrequency().intValue();
        int nf = this.forecastLength(freq);
        int nb = this.backcastLength(freq);
        int n = domain.getLength() + nf;
        domain = new TsDomain(domain.getStart().minus(nb), n);
        TsData ccorr = model.deterministicEffect(domain, ComponentType.CalendarEffect);
        TsData scorr = model.deterministicEffect(domain, ComponentType.Seasonal);
        TsData corr = TsData.add(scorr, ccorr);
        if (corr == null) {
            return 0.0;
        }
        int mq = freq;
        int nyr = n / mq * mq;
        DataBlock data = new DataBlock(corr.internalStorage(), 0, nyr, 1);
        double m = data.sum();
        if (Math.abs(m /= (double)nyr) < 1.0E-8) {
            return 0.0;
        }
        return m;
    }

    @Override
    public TsData getCorrectedSeries(boolean transformed) {
        if (this.noapply) {
            return this.model_.interpolatedSeries(false);
        }
        boolean mul = !transformed && this.model_.isMultiplicative();
        TsData lin = this.model_.linearizedSeries(true);
        if (mul) {
            lin = lin.exp();
        }
        return lin;
    }

    private int forecastLength(int freq) {
        if (this.nf_ == 0 || freq == 0) {
            return 0;
        }
        if (this.nf_ < 0) {
            return -freq * this.nf_;
        }
        return this.nf_;
    }

    private int backcastLength(int freq) {
        if (this.nb_ == 0 || freq == 0) {
            return 0;
        }
        if (this.nb_ < 0) {
            return -freq * this.nb_;
        }
        return this.nb_;
    }

    @Override
    public TsData getCorrectedForecasts(boolean transformed) {
        if (this.nf_ == 0) {
            return null;
        }
        int nf = this.forecastLength(this.model_.description.getFrequency());
        if (this.noapply) {
            return this.model_.forecast(nf, transformed);
        }
        TsData f = this.model_.linearizedForecast(nf, true);
        if (!transformed && this.model_.isMultiplicative()) {
            f.apply(x -> Math.exp(x));
        }
        return f;
    }

    @Override
    public TsData getCorrectedBackcasts(boolean transformed) {
        if (this.nb_ == 0) {
            return null;
        }
        int nb = this.backcastLength(this.model_.description.getFrequency());
        if (this.noapply) {
            return this.model_.backcast(nb, transformed);
        }
        TsData b = this.model_.linearizedBackcast(nb, true);
        if (!transformed && this.model_.isMultiplicative()) {
            b.apply(x -> Math.exp(x));
        }
        return b;
    }

    @Override
    public TsData getCorrection(TsDomain domain, ComponentType type, boolean transformed) {
        if (this.noapply) {
            return null;
        }
        switch (type) {
            case Series: {
                TsData x = this.model_.deterministicEffect(domain, type);
                if (!transformed) {
                    this.model_.backTransform(x, false, false);
                }
                return x;
            }
            case Trend: {
                TsData t = this.model_.deterministicEffect(domain, type);
                if (!transformed) {
                    this.model_.backTransform(t, true, false);
                }
                return t;
            }
            case Seasonal: {
                TsData s = this.model_.deterministicEffect(domain, type);
                TsData c = this.model_.deterministicEffect(domain, ComponentType.CalendarEffect);
                TsData sc = TsData.add(s, c);
                if (!transformed) {
                    this.model_.backTransform(sc, false, true);
                }
                return sc;
            }
            case SeasonallyAdjusted: {
                TsData sa = this.model_.deterministicEffect(domain, type);
                if (!transformed) {
                    this.model_.backTransform(sa, false, false);
                }
                return sa;
            }
            case Undefined: {
                TsData undef = this.model_.deterministicEffect(domain, type);
                if (!transformed) {
                    this.model_.backTransform(undef, false, false);
                }
                return undef;
            }
            case Irregular: {
                TsData i = this.model_.deterministicEffect(domain, type);
                if (!transformed) {
                    this.model_.backTransform(i, false, false);
                }
                return i;
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public double getBiasCorrection(ComponentType type) {
        return 0.0;
    }

    @Override
    public boolean isInitialized() {
        return this.model_ != null;
    }
}

