/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.polynomials;

import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.polynomials.IRootSelector;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.utilities.Jdk6;
import java.util.ArrayList;

public abstract class AbstractRootSelector
implements IRootSelector {
    protected Polynomial m_sel;
    protected Polynomial m_nsel;

    public abstract boolean accept(Complex var1);

    @Override
    public Polynomial getOutofSelection() {
        return this.m_nsel;
    }

    @Override
    public Polynomial getSelection() {
        return this.m_sel;
    }

    @Override
    public boolean select(Polynomial p) {
        if (p.getDegree() == 0) {
            this.m_nsel = p;
            this.m_sel = null;
            return false;
        }
        Complex[] roots = p.roots();
        ArrayList<Complex> sel = new ArrayList<Complex>();
        ArrayList<Complex> nsel = new ArrayList<Complex>();
        for (int i = 0; i < roots.length; ++i) {
            if (this.accept(roots[i])) {
                sel.add(roots[i]);
                continue;
            }
            nsel.add(roots[i]);
        }
        if (sel.isEmpty()) {
            this.m_sel = null;
            this.m_nsel = p;
            return false;
        }
        if (nsel.isEmpty()) {
            this.m_nsel = null;
            this.m_sel = p;
            return true;
        }
        Complex[] rs = Jdk6.Collections.toArray(sel, Complex.class);
        Complex[] rn = Jdk6.Collections.toArray(nsel, Complex.class);
        Complex.lejaOrder(rs);
        Complex.lejaOrder(rn);
        this.m_sel = Polynomial.fromComplexRoots(rs);
        this.m_sel = this.m_sel.times(p.get(0) / this.m_sel.get(0));
        this.m_nsel = Polynomial.fromComplexRoots(rn);
        this.m_nsel = this.m_nsel.divide(this.m_nsel.get(0));
        return true;
    }
}

