## ----include = FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    library(SGP)
    library(SGPdata)

    is_html_output = function() {
        knitr::opts_knit$get("rmarkdown.pandoc.to")=="html"
    }

    knitr::opts_chunk$set(
        collapse=TRUE,
        comment="",
        prompt=TRUE,
        fig.dpi=96)

    if (is_html_output()) {
        options(width=1000)
    }

## ----eval=FALSE, prompt=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  #####################################################################################
#  ###
#  ### R Script for Demonstration SGP analyses
#  ###
#  #####################################################################################
#  
#  ### Load SGP & SGPdata packages
#  
#  require(SGP)
#  require(SGPdata)
#  
#  
#  ### abcSGP
#  
#  Demonstration_SGP <- abcSGP(
#  	sgp_object=sgpData_LONG,
#  	data_supplementary=list(INSTRUCTOR_NUMBER=sgpData_INSTRUCTOR_NUMBER),
#  	parallel.config=list(BACKEND="PARALLEL", WORKERS=list(PERCENTILES=4, BASELINE_PERCENTILES=4, PROJECTIONS=4, LAGGED_PROJECTIONS=4, SGP_SCALE_SCORE_TARGETS=4, SUMMARY=4, GA_PLOTS=4, SG_PLOTS=1)))
#  
#  
#  ### Save results
#  
#  save(Demonstration_SGP, file="Data/Demonstration_SGP.Rdata")

