## version 0.0.4
- **Enhancement**: Complete overhaul of distribution fitting framework
  - New function `fit_dist()`: Unified parameter estimation for probability distributions
    - Supports multiple estimation methods: MLE (Maximum Likelihood), MPS (Maximum Product Spacing) 
      and Method of Moments
    - Implements ties correction methods: Cheng & Amin (1983) 
    - Provides robust error handling with variance-covariance matrix computation
    - Returns comprehensive goodness-of-fit statistics: log-likelihood, AIC, BIC, and
    Kolmogorov-Smirnov test
  - New function `fit_weibull_plot()`: Enhanced Weibull distribution fitting with visualization
    - Replaces and extends `adjWeibull()` functionality (kept as alias for backward compatibility)
    - Adds confidence band visualization using delta method and parametric bootstrap
    - Supports standard and three-parameter Weibull distributions
    - Customizable plotting with parameter estimates and confidence intervals in legend
  - New distribution functions: `dweibull3()`, `pweibull3()`, `qweibull3()`, `rweibull3()` 
    for three-parameter Weibull distribution
  - New S3 methods for `fit_dist` class: `print()`, `summary()`, `coef()`, `vcov()`, 
    `confint()`, `logLik()`, `AIC()`, `BIC()`
    
- **Improvements**: 
  - Refactored codebase for better maintainability and readability
  - `makedata()` function now supports unlimited number of grouping factors
  - Enhanced tolerance parameters (`tol_spacing`, `tol_param`) for numerical stability
  - Better starting value computation for optimization
  - Improved convergence diagnostics

## version 0.0.3

- New Functions: adjWeibull, barkFactor, basal, basalContribution, densityRegen, 
param and others.

- New methods: print.slope, print.angle.

- height' s argument 'base' becomes 'bottom'.

- diameterMean allows 'dbh' only as argument.


## version 0.0.2
- added functions: stacking, circum, makedata, basal, sampleSize

- both of factorize and factorise work now

- diameterMean allows arguments factor1, factor2 and factor3

## version 0.0.1

---


### NEWS.md setup

- added NEWS.md creation with newsmd

