/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.gof;

import umontreal.iro.lecuyer.probdist.NormalDist;

public class FBar {
    private static final double EPSILONSCAN = 1.0E-7;

    private FBar() {
    }

    private static double scanGlaz(int n, double d, int m) {
        double binMoy;
        double jr;
        int j;
        double nr = n;
        double q = 1.0 - d;
        int jmoy = (int)((double)(n + 1) * d);
        if (jmoy < m - 1) {
            jmoy = m - 1;
        }
        double q1 = 0.0;
        for (j = 1; j <= jmoy; ++j) {
            jr = j;
            q1 += Math.log(nr - jr + 1.0) - Math.log(jr);
        }
        q1 += (double)jmoy * Math.log(d) + (nr - (double)jmoy) * Math.log(q);
        q1 = binMoy = Math.exp(q1);
        double jm1r = jmoy - m + 1;
        int signe = (jmoy - m + 1 & 1) != 0 ? -1 : 1;
        double q2 = (double)signe * binMoy;
        double q3 = (double)signe * binMoy * (2.0 - jm1r * jm1r + jm1r);
        double q4 = (double)signe * binMoy * (jm1r + 1.0) * (jm1r + 2.0) * (6.0 + jm1r * jm1r - 5.0 * jm1r);
        signe = (jmoy - m + 1 & 1) != 0 ? -1 : 1;
        jm1r = jmoy - m + 1;
        double bin = binMoy;
        for (j = jmoy + 1; j <= n; ++j) {
            jr = j;
            jm1r += 1.0;
            signe = -signe;
            if ((bin = bin * (nr - jr + 1.0) * d / (jr * q)) < 1.0E-7) break;
            q1 += bin;
            q2 += (double)signe * bin;
            q3 += (double)signe * bin * (2.0 - jm1r * jm1r + jm1r);
            q4 += (double)signe * bin * (jm1r + 1.0) * (jm1r + 2.0) * (6.0 + jm1r * jm1r - 5.0 * jm1r);
        }
        q1 = 1.0 - q1;
        q3 /= 2.0;
        q4 /= 12.0;
        if (m == 3) {
            q4 = nr * (nr - 1.0) * d * d * Math.pow(q, nr - 2.0) / 8.0 + nr * d * 2.0 * Math.pow(1.0 - 2.0 * d, nr - 1.0) - 4.0 * Math.pow(1.0 - 2.0 * d, nr);
            if (d < 0.3333333333333333) {
                q4 += nr * d * 2.0 * Math.pow(1.0 - 3.0 * d, nr - 1.0) + 4.0 * Math.pow(1.0 - 3.0 * d, nr);
            }
        }
        q3 = q1 - q2 - q3;
        q4 = q3 - q4;
        double temp = Math.log(q3) + (nr - (double)m - 2.0) * Math.log(q4 / q3);
        if (temp >= 0.0) {
            return 0.0;
        }
        if (temp < -30.0) {
            return 1.0;
        }
        q4 = Math.exp(temp);
        return 1.0 - q4;
    }

    private static double scanWNeff(int n, double d, int m) {
        int j;
        double q = 1.0 - d;
        double sum = 0.0;
        for (j = 1; j <= m; ++j) {
            sum += Math.log(n - j + 1) - Math.log(j);
        }
        double bin = Math.exp(sum += (double)m * Math.log(d) + (double)(n - m) * Math.log(q));
        double temp = ((double)m / d - (double)n - 1.0) * bin;
        sum = bin;
        for (j = m + 1; j <= n && !((bin *= (double)(n - j + 1) * d / ((double)j * q)) < 1.0E-7); ++j) {
            sum += bin;
        }
        sum = 2.0 * sum + temp;
        return sum;
    }

    private static double scanAsympt(int n, double d, int m) {
        double theta = Math.sqrt(d / (1.0 - d));
        double temp = Math.sqrt(n);
        double kappa = (double)m / (d * temp) - temp;
        temp = theta * kappa;
        temp = temp * temp / 2.0;
        double sum = 2.0 * (1.0 - NormalDist.cdf01(theta * kappa)) + kappa * theta * Math.exp(-temp) / (d * Math.sqrt(Math.PI * 2));
        return sum;
    }

    public static double scan(int n, double d, int m) {
        if (n < 2) {
            throw new IllegalArgumentException("Calling scan with n < 2");
        }
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Calling scan with d outside (0,1)");
        }
        if (m > n) {
            return 0.0;
        }
        if (m <= 1) {
            return 1.0;
        }
        if (m <= 2) {
            if ((double)(n - 1) * d >= 1.0) {
                return 1.0;
            }
            return 1.0 - Math.pow(1.0 - (double)(n - 1) * d, n);
        }
        if (d >= 0.5 && (double)m <= (double)(n + 1) / 2.0) {
            return 1.0;
        }
        if (d > 0.5) {
            return -1.0;
        }
        double mu = (double)n * d;
        if ((double)m <= mu + d) {
            return 1.0;
        }
        if (mu <= 10.0) {
            return FBar.scanGlaz(n, d, m);
        }
        double prob = FBar.scanAsympt(n, d, m);
        if ((d >= 0.3 && (double)n >= 50.0 || (double)n * d * d >= 250.0 && d < 0.3) && prob <= 0.4) {
            return prob;
        }
        prob = FBar.scanWNeff(n, d, m);
        if (prob <= 0.4) {
            return prob;
        }
        prob = FBar.scanGlaz(n, d, m);
        if (prob > 0.4 && prob <= 1.0) {
            return prob;
        }
        return 1.0;
    }
}

