/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified;

import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.integer.extension.FCBinSConstraint;
import choco.cp.solver.constraints.reified.leaves.bool.NotNode;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.branch.Extension;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.SConstraintType;
import choco.kernel.solver.constraints.integer.extension.BinRelation;
import choco.kernel.solver.constraints.integer.extension.TuplesTest;
import choco.kernel.solver.constraints.reified.BoolNode;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class ExpressionSConstraint
extends TuplesTest
implements SConstraint,
BinRelation {
    protected IntDomainVar[] vars;
    protected INode expr;
    protected Boolean decomposeExp = null;
    protected int levelAc = -1;
    protected SConstraint knownIntensionalConstraint = null;
    protected int[] bint;

    public ExpressionSConstraint(BoolNode expr, Boolean decomp) {
        this.expr = (INode)((Object)expr);
        this.bint = new int[2];
        this.decomposeExp = decomp;
    }

    public ExpressionSConstraint(BoolNode expr) {
        this.expr = (INode)((Object)expr);
        this.bint = new int[2];
    }

    public INode getRootNode() {
        return this.expr;
    }

    public Boolean isDecomposeExp() {
        return this.decomposeExp;
    }

    public void setDecomposeExp(Boolean decomposeExp) {
        this.decomposeExp = decomposeExp;
    }

    public void setScope(Solver s) {
        if (this.vars == null) {
            this.vars = this.expr.getScope(s);
            this.expr.setIndexes(this.vars);
        }
    }

    public IntDomainVar[] getVars() {
        return this.vars;
    }

    @Override
    public int getNbVars() {
        if (this.vars != null) {
            return this.vars.length;
        }
        return 0;
    }

    public Var getVar(int i) {
        return this.vars[i];
    }

    public Var getVarQuick(int i) {
        return this.vars[i];
    }

    public void setVar(int i, Var v) {
        this.vars[i] = (IntDomainVar)v;
    }

    public int getLevelAc() {
        return this.levelAc;
    }

    public void setLevelAc(int levelAc) {
        this.levelAc = levelAc;
    }

    public boolean checkDecompositionIsPossible() {
        return this.expr.isDecompositionPossible();
    }

    public boolean checkIsReified() {
        return this.expr.isReified();
    }

    @Override
    public ExpressionSConstraint getOpposite() {
        return new ExpressionSConstraint(new NotNode(new INode[]{this.expr}), this.decomposeExp);
    }

    public SConstraint getKnownIntensionalConstraint() {
        return this.knownIntensionalConstraint;
    }

    public void setKnownIntensionalConstraint(SConstraint knownIntensionalConstraint) {
        this.knownIntensionalConstraint = knownIntensionalConstraint;
    }

    @Override
    public boolean checkCouple(int a, int b) {
        this.bint[0] = a;
        this.bint[1] = b;
        return this.checkTuple(this.bint);
    }

    @Override
    public boolean isConsistent(int x, int y) {
        return this.checkCouple(x, y);
    }

    @Override
    public boolean checkTuple(int[] tuple) {
        return ((BoolNode)((Object)this.expr)).checkTuple(tuple);
    }

    public SConstraint getExtensionnal(Solver s) {
        if (this.getNbVars() == 0) {
            return this.getDecomposition(s);
        }
        if (this.getNbVars() == 2 && this.vars[0].hasEnumeratedDomain() && this.vars[1].hasEnumeratedDomain()) {
            int maxspan = Math.max(this.vars[0].getSup() - this.vars[0].getInf() + 1, this.vars[1].getSup() - this.vars[1].getInf() + 1);
            int maxdsize = Math.max(this.vars[0].getDomainSize(), this.vars[1].getDomainSize());
            if (this.levelAc == 1 || this.levelAc == -1 && maxspan >= 1000 && maxdsize < maxspan) {
                return new FCBinSConstraint(this.vars[0], this.vars[1], this);
            }
            return ((CPSolver)s).relationPairAC(this.vars[0], this.vars[1], this);
        }
        if (this.levelAc == -1 && this.getNbVars() < 6 || this.levelAc == 0) {
            return s.relationTupleAC(this.vars, this);
        }
        return CPSolver.relationTupleFC(this.vars, this);
    }

    public SConstraint getDecomposition(Solver s) {
        return ((BoolNode)((Object)this.expr)).extractConstraint(s);
    }

    public double cardProd() {
        double prodsize = 1.0;
        for (int i = 0; i < this.vars.length; ++i) {
            prodsize *= (double)this.vars[i].getDomainSize();
        }
        return prodsize;
    }

    public List<int[]> getTuples(Solver s) {
        this.setScope(s);
        LinkedList<int[]> ltuples = new LinkedList<int[]>();
        int size = this.vars.length;
        int[] currentSupport = new int[size];
        DisposableIntIterator[] seekIter = new DisposableIntIterator[size];
        for (int i = 0; i < size; ++i) {
            seekIter[i] = this.vars[i].getDomain().getIterator();
            currentSupport[i] = seekIter[i].next();
        }
        if (this.isConsistent(currentSupport)) {
            ltuples.add(ExpressionSConstraint.copy(currentSupport));
        }
        int k = 0;
        while (k < this.vars.length) {
            if (!seekIter[k].hasNext()) {
                seekIter[k].dispose();
                seekIter[k] = this.vars[k].getDomain().getIterator();
                currentSupport[k] = seekIter[k].next();
                ++k;
                continue;
            }
            currentSupport[k] = seekIter[k].next();
            if (this.isConsistent(currentSupport)) {
                ltuples.add(ExpressionSConstraint.copy(currentSupport));
            }
            k = 0;
        }
        return ltuples;
    }

    @Override
    public String pretty() {
        return this.expr.pretty();
    }

    @Override
    public SConstraintType getConstraintType() {
        return SConstraintType.EXPRESSION;
    }

    public Iterator<IntegerVariable> getVariableIterator() {
        IntegerVariable[] vs = this.expr.getModelScope();
        LinkedList<IntegerVariable> lvar = new LinkedList<IntegerVariable>();
        lvar.addAll(Arrays.asList(vs));
        return lvar.iterator();
    }

    @Override
    public void setConstraintIndex(int i, int idx) {
        throw new SolverException("setConstraintIdx should not be called on a predicat");
    }

    @Override
    public int getConstraintIdx(int idx) {
        throw new SolverException("getConstraintIdx should not be called on a predicat");
    }

    @Override
    public boolean isSatisfied() {
        throw new SolverException("isSatisfiedTo should not be called on a predicat");
    }

    public AbstractSConstraint opposite(Solver solver) {
        throw new SolverException("opposite should not be called on a predicat");
    }

    public static int[] copy(int[] tab) {
        int[] tab2 = new int[tab.length];
        System.arraycopy(tab, 0, tab2, 0, tab.length);
        return tab2;
    }

    @Override
    public Extension getExtension(int extensionNumber) {
        return null;
    }

    @Override
    public void addExtension(int extensionNumber) {
    }

    @Override
    public int getFineDegree(int idx) {
        return 1;
    }

    public static class VarMinDomComparator
    implements Comparator {
        public int compare(Object o, Object o1) {
            IntDomainVar v1 = (IntDomainVar)o;
            IntDomainVar v2 = (IntDomainVar)o1;
            if (v1.getDomainSize() < v2.getDomainSize()) {
                return -1;
            }
            if (v1.getDomainSize() == v2.getDomainSize()) {
                return 0;
            }
            return 1;
        }
    }
}

