/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.diagnostics;

import jdplus.sa.base.core.diagnostics.ResidualSeasonalityTestsOptions;
import jdplus.sa.base.core.tests.AutoRegressiveSpectrumTest;
import jdplus.sa.base.core.tests.FTest;
import jdplus.sa.base.core.tests.Friedman;
import jdplus.sa.base.core.tests.KruskalWallis;
import jdplus.sa.base.core.tests.PeriodogramTest;
import jdplus.sa.base.core.tests.Qs;
import jdplus.sa.base.core.tests.SpectralPeaks;
import jdplus.sa.base.core.tests.TukeySpectrumPeaksTest;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.core.modelling.DifferencingResult;
import lombok.Generated;
import org.jspecify.annotations.NonNull;

public class ResidualSeasonalityTests {
    private final TsData series;
    private final DifferencingResult differencing;
    private final ResidualSeasonalityTestsOptions options;
    private volatile StatisticalTest fTest;
    private volatile StatisticalTest qsTest;
    private volatile StatisticalTest friedmanTest;
    private volatile StatisticalTest kruskalWallisTest;
    private volatile StatisticalTest periodogramTest;
    private volatile SpectralPeaks[] spectralPeaks;

    private ResidualSeasonalityTests(TsData series, int ndiff, boolean mean, ResidualSeasonalityTestsOptions options) {
        this.series = series;
        this.differencing = DifferencingResult.of((DoubleSeq)series.getValues(), (int)series.getAnnualFrequency(), (int)ndiff, (boolean)mean);
        this.options = options;
    }

    public int annualFrequency() {
        return this.series.getAnnualFrequency();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatisticalTest qsTest() {
        StatisticalTest test = this.qsTest;
        if (test == null) {
            ResidualSeasonalityTests residualSeasonalityTests = this;
            synchronized (residualSeasonalityTests) {
                test = this.qsTest;
                if (test == null) {
                    int ifreq = this.series.getAnnualFrequency();
                    DoubleSeq ds = this.differencing.getDifferenced();
                    if (this.options.getQslast() > 0) {
                        ds = ds.drop(Math.max(0, ds.length() - ifreq * this.options.getQslast()), 0);
                    }
                    this.qsTest = test = new Qs(ds, ifreq).autoCorrelationsCount(this.options.getQsLags()).build();
                }
            }
        }
        return test;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatisticalTest friedmanTest() {
        StatisticalTest test = this.friedmanTest;
        if (test == null) {
            ResidualSeasonalityTests residualSeasonalityTests = this;
            synchronized (residualSeasonalityTests) {
                test = this.friedmanTest;
                if (test == null) {
                    DoubleSeq ds = this.differencing.getDifferenced();
                    this.friedmanTest = test = new Friedman(ds, this.annualFrequency()).build();
                }
            }
        }
        return test;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatisticalTest kruskalWallisTest() {
        StatisticalTest test = this.kruskalWallisTest;
        if (test == null) {
            ResidualSeasonalityTests residualSeasonalityTests = this;
            synchronized (residualSeasonalityTests) {
                test = this.kruskalWallisTest;
                if (test == null) {
                    DoubleSeq ds = this.differencing.getDifferenced();
                    this.kruskalWallisTest = test = new KruskalWallis(ds, this.annualFrequency()).build();
                }
            }
        }
        return test;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatisticalTest periodogramTest() {
        StatisticalTest test = this.periodogramTest;
        if (test == null) {
            ResidualSeasonalityTests residualSeasonalityTests = this;
            synchronized (residualSeasonalityTests) {
                test = this.periodogramTest;
                if (test == null) {
                    DoubleSeq ds = this.differencing.getDifferenced();
                    this.periodogramTest = test = new PeriodogramTest(ds, this.annualFrequency()).buildF();
                }
            }
        }
        return test;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatisticalTest fTest() {
        StatisticalTest test = this.fTest;
        if (test == null) {
            ResidualSeasonalityTests residualSeasonalityTests = this;
            synchronized (residualSeasonalityTests) {
                test = this.fTest;
                if (test == null) {
                    this.fTest = test = new FTest(this.series.getValues(), this.annualFrequency()).model(this.options.getModelForFTest()).ncycles(this.options.getFlast()).build();
                }
            }
        }
        return test;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpectralPeaks[] spectralPeaks() {
        SpectralPeaks[] sp = this.spectralPeaks;
        if (sp == null) {
            ResidualSeasonalityTests residualSeasonalityTests = this;
            synchronized (residualSeasonalityTests) {
                sp = this.spectralPeaks;
                if (sp == null) {
                    int ifreq = this.annualFrequency();
                    DoubleSeq ds = this.differencing.getDifferenced();
                    AutoRegressiveSpectrumTest arPeaks = new AutoRegressiveSpectrumTest();
                    TukeySpectrumPeaksTest tPeaks = new TukeySpectrumPeaksTest();
                    if (!arPeaks.test(ds, ifreq) || !tPeaks.test(ds, ifreq)) {
                        return null;
                    }
                    int[] a = arPeaks.seasonalPeaks(0.9, 0.99);
                    int[] t = tPeaks.seasonalPeaks(0.9, 0.99);
                    sp = new SpectralPeaks[ifreq / 2];
                    for (int i = 0; i < sp.length; ++i) {
                        SpectralPeaks.AR ar = SpectralPeaks.AR.none;
                        SpectralPeaks.Tukey tu = SpectralPeaks.Tukey.none;
                        if (a != null && a.length > i) {
                            ar = SpectralPeaks.AR.fromInt(a[i]);
                        }
                        if (t != null && t.length > i) {
                            tu = SpectralPeaks.Tukey.fromInt(t[i]);
                        }
                        sp[i] = new SpectralPeaks(ar, tu);
                    }
                    this.spectralPeaks = sp;
                }
            }
        }
        return sp;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public TsData getSeries() {
        return this.series;
    }

    @Generated
    public DifferencingResult getDifferencing() {
        return this.differencing;
    }

    @Generated
    public ResidualSeasonalityTestsOptions getOptions() {
        return this.options;
    }

    @Generated
    private StatisticalTest getFTest() {
        return this.fTest;
    }

    @Generated
    private StatisticalTest getQsTest() {
        return this.qsTest;
    }

    @Generated
    private StatisticalTest getFriedmanTest() {
        return this.friedmanTest;
    }

    @Generated
    private StatisticalTest getKruskalWallisTest() {
        return this.kruskalWallisTest;
    }

    @Generated
    private StatisticalTest getPeriodogramTest() {
        return this.periodogramTest;
    }

    @Generated
    private SpectralPeaks[] getSpectralPeaks() {
        return this.spectralPeaks;
    }

    @Generated
    public static class Builder {
        @Generated
        private TsData series;
        @Generated
        private int ndiff;
        @Generated
        private boolean mean;
        @Generated
        private ResidualSeasonalityTestsOptions options;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder series(TsData series) {
            this.series = series;
            return this;
        }

        @Generated
        public @NonNull Builder ndiff(int ndiff) {
            this.ndiff = ndiff;
            return this;
        }

        @Generated
        public @NonNull Builder mean(boolean mean) {
            this.mean = mean;
            return this;
        }

        @Generated
        public @NonNull Builder options(ResidualSeasonalityTestsOptions options) {
            this.options = options;
            return this;
        }

        @Generated
        public @NonNull ResidualSeasonalityTests build() {
            return new ResidualSeasonalityTests(this.series, this.ndiff, this.mean, this.options);
        }

        @Generated
        public @NonNull String toString() {
            return "ResidualSeasonalityTests.Builder(series=" + String.valueOf(this.series) + ", ndiff=" + this.ndiff + ", mean=" + this.mean + ", options=" + String.valueOf(this.options) + ")";
        }
    }
}

