/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.api;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jdplus.sa.base.api.SaProcessingFactory;

public final class SaProcessingFactoryLoader {
    private static final Iterable<SaProcessingFactory> SOURCE = ServiceLoader.load(SaProcessingFactory.class);
    private static final AtomicReference<List<SaProcessingFactory>> RESOURCE = new AtomicReference<List<SaProcessingFactory>>(SaProcessingFactoryLoader.doLoad());
    private static final Consumer<Iterable> CLEANER = loader -> ((ServiceLoader)loader).reload();

    private SaProcessingFactoryLoader() {
    }

    private static List<SaProcessingFactory> doLoad() {
        return StreamSupport.stream(SOURCE.spliterator(), false).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public static List<SaProcessingFactory> get() {
        return RESOURCE.get();
    }

    public static void set(List<SaProcessingFactory> newValue) {
        RESOURCE.set(Objects.requireNonNull(newValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload() {
        Iterable<SaProcessingFactory> iterable = SOURCE;
        synchronized (iterable) {
            CLEANER.accept(SOURCE);
            SaProcessingFactoryLoader.set(SaProcessingFactoryLoader.doLoad());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Iterable<SaProcessingFactory> iterable = SOURCE;
        synchronized (iterable) {
            SaProcessingFactoryLoader.set(SaProcessingFactoryLoader.doLoad());
        }
    }
}

