/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.data;

import java.util.Arrays;
import java.util.function.IntToDoubleFunction;
import java.util.stream.DoubleStream;
import jdplus.toolkit.base.api.data.DoubleSeq;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.design.Internal;
import org.jspecify.annotations.Nullable;

public final class Doubles
implements DoubleSeq {
    public static final Doubles EMPTY = Doubles.ofInternal(new double[0]);
    public static final Doubles ZERO = Doubles.of(0.0);
    public static final Doubles ONE = Doubles.of(1.0);
    private final double[] values;

    @NonNull
    public static Doubles of(int length, @NonNull IntToDoubleFunction generator) {
        if (generator == null) {
            throw new NullPointerException("generator is marked non-null but is null");
        }
        double[] values = new double[length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = generator.applyAsDouble(i);
        }
        return new Doubles(values);
    }

    @NonNull
    public static Doubles of(@NonNull DoubleStream stream) {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        return new Doubles(stream.toArray());
    }

    @NonNull
    public static Doubles of(@NonNull DoubleSeq seq) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        return seq instanceof Doubles ? (Doubles)seq : new Doubles(seq.toArray());
    }

    @NonNull
    public static Doubles of(double value) {
        return new Doubles(new double[]{value});
    }

    @NonNull
    public static Doubles of(double @NonNull [] values) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return new Doubles((double[])values.clone());
    }

    @Internal
    @NonNull
    public static Doubles ofInternal(double @NonNull [] safeArray) {
        if (safeArray == null) {
            throw new NullPointerException("safeArray is marked non-null but is null");
        }
        return new Doubles(safeArray);
    }

    @Override
    public double get(int index) throws IndexOutOfBoundsException {
        return this.values[index];
    }

    @Override
    public int length() {
        return this.values.length;
    }

    public String toString() {
        return DoubleSeq.format(this);
    }

    @Generated
    private Doubles(double[] values) {
        this.values = values;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Doubles)) {
            return false;
        }
        Doubles other = (Doubles)o;
        return Arrays.equals(this.values, other.values);
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.values);
        return result;
    }
}

