/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.arima;

import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.math.linearfilters.RationalBackFilter;

public class AutoRegressiveDistance {
    public static double compute(IArimaModel a, IArimaModel b, int npi) {
        RationalBackFilter pia = a.getPiWeights();
        RationalBackFilter pib = b.getPiWeights();
        double[] wa = pia.getWeights(npi + 1);
        double[] wb = pib.getWeights(npi + 1);
        double d = 0.0;
        for (int i = 1; i <= npi; ++i) {
            double di = wa[i] - wb[i];
            d += di * di;
        }
        return Math.sqrt(d);
    }
}

