/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data.analysis;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.AutoCovariances;
import jdplus.toolkit.base.core.data.analysis.Taper;
import jdplus.toolkit.base.core.stats.DescriptiveStatistics;

public class DurbinAlgorithm {
    private double[] cxx;
    private double sd;
    private double aic;
    private double[] x;
    private double[] a;
    private static final double SMALL = 1.0E-9;
    private boolean mean = true;
    private Taper taper;

    public double getAutocovariance(int lag) {
        return this.cxx[lag];
    }

    public int getMaxLag() {
        return this.cxx == null ? 0 : this.cxx.length - 1;
    }

    public void setTaper(Taper taper) {
        this.taper = taper;
    }

    public Taper getTaper() {
        return this.taper;
    }

    public boolean solve(DoubleSeq x, int l) {
        this.x = new double[x.length()];
        x.copyTo(this.x, 0);
        return this.calc(l);
    }

    public double[] getCoefficients() {
        return this.a;
    }

    public double getAIC() {
        return this.aic;
    }

    public double getInnovationVariance() {
        return this.sd;
    }

    public boolean isMeanCorrection() {
        return this.mean;
    }

    public void setMeanCorrection(boolean mean) {
        this.mean = mean;
    }

    private boolean calc(int l) {
        if (!this.checkMean()) {
            return false;
        }
        if (this.taper != null) {
            this.taper.process(this.x);
        }
        if (!this.calcCov(l)) {
            return false;
        }
        this.iterate(l);
        return true;
    }

    private boolean checkMean() {
        int i;
        double sum = 0.0;
        int nm = 0;
        for (i = 0; i < this.x.length; ++i) {
            if (!Double.isFinite(this.x[i])) {
                ++nm;
                continue;
            }
            if (!this.mean) continue;
            sum += this.x[i];
        }
        if (nm == this.x.length) {
            return false;
        }
        if (sum != 0.0) {
            sum /= (double)(this.x.length - nm);
            for (i = 0; i < this.x.length; ++i) {
                if (!Double.isFinite(this.x[i])) continue;
                int n = i;
                this.x[n] = this.x[n] - sum;
            }
        }
        return true;
    }

    private boolean calcCov(int l) {
        IntToDoubleFunction acf = AutoCovariances.autoCovarianceFunction((DoubleSeq)DoubleSeq.of((double[])this.x), (double)0.0);
        double v = acf.applyAsDouble(0);
        if (DescriptiveStatistics.isSmall(v)) {
            return false;
        }
        this.cxx = new double[l + 1];
        this.cxx[0] = v;
        for (int i = 1; i <= l; ++i) {
            this.cxx[i] = acf.applyAsDouble(i);
        }
        return true;
    }

    private void iterate(int l) {
        double sdr;
        double caic;
        this.a = new double[l];
        int n = this.x.length;
        double csd = this.cxx[0];
        this.aic = caic = (double)n * Math.log(csd);
        this.sd = csd;
        double se = this.cxx[1];
        double[] b = new double[l];
        for (int m = 0; m < l && !((sdr = csd / this.cxx[0]) < 1.0E-9); ++m) {
            int i;
            double d;
            this.a[m] = d = se / csd;
            csd = (1.0 - d * d) * csd;
            caic = (double)n * Math.log(csd) + (double)(2 * (m + 1));
            if (m != 0) {
                for (i = 0; i <= m - 1; ++i) {
                    int n2 = i;
                    this.a[n2] = this.a[n2] - d * b[i];
                }
            }
            for (i = 0; i <= m; ++i) {
                b[i] = this.a[m - i];
            }
            if (this.aic > caic) {
                this.aic = caic;
                this.sd = csd;
            }
            if (m == l - 1) continue;
            se = this.cxx[m + 2];
            for (i = 0; i <= m; ++i) {
                se -= b[i] * this.cxx[i + 1];
            }
        }
        for (int i = 0; i < l; ++i) {
            this.a[i] = -this.a[i];
        }
    }
}

