/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.dstats;

import internal.toolkit.base.core.dstats.ProbInvFinder;
import java.util.concurrent.atomic.AtomicReference;
import jdplus.toolkit.base.api.dstats.BoundaryType;
import jdplus.toolkit.base.api.dstats.ContinuousDistribution;
import jdplus.toolkit.base.api.dstats.DStatException;
import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.api.stats.ProbabilityType;
import jdplus.toolkit.base.core.dstats.Chi2;
import jdplus.toolkit.base.core.dstats.SpecialFunctions;
import lombok.NonNull;

public final class F
implements ContinuousDistribution {
    private final double k1;
    private final double k2;
    private final AtomicReference<Chi2> num;
    private final AtomicReference<Chi2> denom;

    public F(double ndf, double ddf) {
        this.k1 = ndf;
        this.k2 = ddf;
        this.num = new AtomicReference();
        this.denom = new AtomicReference();
    }

    public double getDensity(double x) {
        return SpecialFunctions.FDensity(x, this.k1, this.k2);
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("F with ");
        sb.append(this.k1);
        sb.append(" degrees of freedom in the nominator and ");
        sb.append(this.k2);
        sb.append(" degrees of freedom in the denominator");
        return sb.toString();
    }

    public double getDFDenom() {
        return this.k2;
    }

    public double getDFNum() {
        return this.k1;
    }

    public double getExpectation() {
        if (this.k2 <= 2.0) {
            throw new DStatException("Undefined", "F");
        }
        return this.k2 / (this.k2 - 2.0);
    }

    public double getLeftBound() {
        return 0.0;
    }

    public double getProbability(double x, ProbabilityType pt) {
        if (pt == ProbabilityType.Point) {
            return 0.0;
        }
        double res = SpecialFunctions.FProbability(x, this.k1, this.k2);
        if (pt == ProbabilityType.Lower) {
            res = 1.0 - res;
        }
        return res;
    }

    public double getProbabilityInverse(double p, ProbabilityType pt) {
        if (pt == ProbabilityType.Upper) {
            p = 1.0 - p;
        }
        if (p < 1.0E-15 || 1.0 - p < 1.0E-15) {
            throw new DStatException("Can't compute probability inverse (value is too near 0 or 1)", "F");
        }
        double start = this.k2 <= 2.0 ? 1.0 : this.k2 / (this.k2 - 2.0);
        return ProbInvFinder.find(p, start, 1.0E-15, 1.0E-9, this);
    }

    public double getRightBound() {
        return Double.POSITIVE_INFINITY;
    }

    public double getVariance() throws DStatException {
        if (this.k2 <= 2.0) {
            throw new DStatException("Undefined", "F");
        }
        if (this.k2 <= 4.0) {
            return Double.POSITIVE_INFINITY;
        }
        double top = 2.0 * this.k2 * this.k2 * (this.k1 + this.k2 - 2.0);
        double bot = this.k1 * (this.k2 - 2.0) * (this.k2 - 2.0) * (this.k2 - 4.0);
        return top / bot;
    }

    public BoundaryType hasLeftBound() {
        return this.k1 <= 2.0 ? BoundaryType.Asymptotical : BoundaryType.Finite;
    }

    public BoundaryType hasRightBound() {
        return BoundaryType.None;
    }

    public boolean isSymmetrical() {
        return false;
    }

    public double random(@NonNull RandomNumberGenerator rng) {
        if (rng == null) {
            throw new NullPointerException("rng is marked non-null but is null");
        }
        Chi2 cnum = this.num.get();
        Chi2 cdenom = this.denom.get();
        if (cnum == null) {
            cnum = new Chi2(this.k1);
            this.num.set(cnum);
        }
        if (cdenom == null) {
            cdenom = new Chi2(this.k2);
            this.denom.set(cdenom);
        }
        return cnum.random(rng) / this.k1 / (cdenom.random(rng) / this.k2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("F(");
        sb.append(this.k1);
        sb.append(',');
        sb.append(this.k2);
        sb.append(')');
        return sb.toString();
    }
}

