/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.functions;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.IParametersDomain;
import jdplus.toolkit.base.core.math.functions.ParamValidation;

public class DefaultDomain
implements IParametersDomain {
    private final int dim;
    private final double epsilon;

    public DefaultDomain(int n, double eps) {
        this.dim = n;
        this.epsilon = eps;
    }

    @Override
    public boolean checkBoundaries(DoubleSeq inparams) {
        return true;
    }

    @Override
    public double epsilon(DoubleSeq inparams, int idx) {
        return inparams.get(idx) * this.epsilon;
    }

    @Override
    public int getDim() {
        return this.dim;
    }

    @Override
    public String getDescription(int idx) {
        return "parameter " + idx;
    }

    @Override
    public double lbound(int idx) {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double ubound(int idx) {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public ParamValidation validate(DataBlock ioparams) {
        return ParamValidation.Valid;
    }
}

