/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.functions.ssq;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.math.functions.FunctionMinimizer;
import jdplus.toolkit.base.core.math.functions.IFunction;
import jdplus.toolkit.base.core.math.functions.IFunctionPoint;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunction;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunctionPoint;
import jdplus.toolkit.base.core.math.functions.ssq.SsqFunctionMinimizer;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;

public class ProxyMinimizer
implements FunctionMinimizer {
    private final SsqFunctionMinimizer minimizer;

    public static FunctionMinimizer.Builder builder(SsqFunctionMinimizer.Builder builder) {
        return new ProxyBuilder(builder);
    }

    public ProxyMinimizer(SsqFunctionMinimizer min) {
        this.minimizer = min;
    }

    public SsqFunctionMinimizer getCore() {
        return this.minimizer;
    }

    @Override
    public FastMatrix curvatureAtMinimum() {
        return this.minimizer.curvatureAtMinimum();
    }

    @Override
    public DoubleSeq gradientAtMinimum() {
        return this.minimizer.gradientAtMinimum();
    }

    @Override
    public double getObjective() {
        return this.minimizer.getObjective();
    }

    @Override
    public IFunctionPoint getResult() {
        return (IFunctionPoint)((Object)this.minimizer.getResult());
    }

    @Override
    public boolean minimize(IFunctionPoint start) {
        IFunction function = start.getFunction();
        if (!(function instanceof ISsqFunction)) {
            return false;
        }
        ISsqFunction fn = (ISsqFunction)((Object)function);
        ISsqFunctionPoint s = fn.ssqEvaluate(start.getParameters());
        return this.minimizer.minimize(s);
    }

    @Override
    public int getIterationsCount() {
        return this.minimizer.getIterationsCount();
    }

    public static class ProxyBuilder
    implements FunctionMinimizer.Builder {
        private final SsqFunctionMinimizer.Builder builder;

        private ProxyBuilder(SsqFunctionMinimizer.Builder builder) {
            this.builder = builder;
        }

        @Override
        public FunctionMinimizer.Builder functionPrecision(double eps) {
            this.builder.functionPrecision(eps);
            return this;
        }

        @Override
        public FunctionMinimizer.Builder maxIter(int niter) {
            this.builder.maxIter(niter);
            return this;
        }

        @Override
        public FunctionMinimizer build() {
            return new ProxyMinimizer(this.builder.build());
        }
    }
}

