/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.data.LogSign;
import jdplus.toolkit.base.core.math.matrices.CPointer;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.math.matrices.lapack.LAIC1;
import lombok.Generated;

public final class UpperTriangularMatrix {
    public static void randomize(FastMatrix M, RandomNumberGenerator rng) {
        M.set((r, c) -> r < c ? 0.0 : rng.nextDouble());
    }

    public static int rank(FastMatrix U, double rcond) {
        return UpperTriangularMatrix.fastRank(U, rcond);
    }

    public static int fastRank(FastMatrix U, double rcond) {
        return U.diagonal().count(x -> Math.abs(x) > rcond);
    }

    public static int robustRank(FastMatrix U, double rcond) {
        int rank;
        double smax;
        DoubleSeqCursor.OnMutable cursor = U.diagonal().cursor();
        double smin = smax = Math.abs(cursor.getAndNext());
        if (smax == 0.0) {
            return 0;
        }
        int n = U.getRowsCount();
        double[] xmin = new double[n];
        double[] xmax = new double[n];
        xmin[0] = 1.0;
        xmax[0] = 1.0;
        LAIC1 cmax = new LAIC1();
        LAIC1 cmin = new LAIC1();
        CPointer pxmax = new CPointer(xmax, 0);
        CPointer pxmin = new CPointer(xmin, 0);
        CPointer pw = new CPointer(U.getStorage(), U.getStartPosition());
        for (rank = 1; rank < n; ++rank) {
            pw.move(U.getColumnIncrement());
            double urr = cursor.getAndNext();
            cmin.minSingularValue(rank, pxmin, smin, pw, urr);
            cmax.maxSingularValue(rank, pxmax, smax, pw, urr);
            double sminpr = cmin.getSestpr();
            double smaxpr = cmax.getSestpr();
            if (smaxpr * rcond > sminpr) break;
            int i = 0;
            while (i < rank - 1) {
                int n2 = i;
                xmin[n2] = xmin[n2] * cmin.getS();
                int n3 = i++;
                xmax[n3] = xmax[n3] * cmax.getS();
            }
            xmin[rank] = cmin.getC();
            xmax[rank] = cmax.getC();
            smin = sminpr;
            smax = smaxpr;
        }
        return rank;
    }

    public static void solveUx(FastMatrix U, DataBlock x, double zero) {
        UpperTriangularMatrix.solveUx(U, x.getStorage(), x.getStartPosition(), x.getIncrement(), zero);
    }

    public static void solveUx(FastMatrix U, DataBlock x) {
        UpperTriangularMatrix.solveUx(U, x.getStorage(), x.getStartPosition(), x.getIncrement(), 0.0);
    }

    public static void solvexU(FastMatrix U, DataBlock x) {
        UpperTriangularMatrix.solveUtx(U, x.getStorage(), x.getStartPosition(), x.getIncrement(), 0.0);
    }

    public static void solvexU(FastMatrix U, DataBlock x, double zero) {
        UpperTriangularMatrix.solveUtx(U, x.getStorage(), x.getStartPosition(), x.getIncrement(), zero);
    }

    public static void solveXU(FastMatrix U, FastMatrix B) throws MatrixException {
        UpperTriangularMatrix.solveXU(U, B, 0.0);
    }

    public static void solveXU(FastMatrix U, FastMatrix B, double zero) throws MatrixException {
        int nc = B.getColumnsCount();
        if (nc != U.getRowsCount()) {
            throw new MatrixException("m_err_dim");
        }
        DataBlockIterator rows = B.rowsIterator();
        while (rows.hasNext()) {
            DataBlock r = rows.next();
            UpperTriangularMatrix.solveUtx(U, r.getStorage(), r.getStartPosition(), r.getIncrement(), zero);
        }
    }

    public static void solveUX(FastMatrix U, FastMatrix M) throws MatrixException {
        UpperTriangularMatrix.solveUX(U, M, 0.0);
    }

    public static void solveUX(FastMatrix U, FastMatrix M, double zero) throws MatrixException {
        int nr = M.getRowsCount();
        int nc = M.getColumnsCount();
        if (nr != U.getRowsCount()) {
            throw new MatrixException("m_err_dim");
        }
        double[] pb = M.getStorage();
        int start = M.getStartPosition();
        int lda = M.getColumnIncrement();
        int bmax = start + nc * lda;
        for (int b = start; b < bmax; b += lda) {
            UpperTriangularMatrix.solveUx(U, pb, b, 1, zero);
        }
    }

    public static void solveXUt(FastMatrix U, FastMatrix M, double zero) throws MatrixException {
        int nr = M.getColumnsCount();
        if (nr != U.getRowsCount()) {
            throw new MatrixException("m_err_dim");
        }
        DataBlockIterator rows = M.rowsIterator();
        while (rows.hasNext()) {
            DataBlock r = rows.next();
            UpperTriangularMatrix.solveUx(U, r.getStorage(), r.getStartPosition(), r.getIncrement(), zero);
        }
    }

    public static void solveXUt(FastMatrix U, FastMatrix M) throws MatrixException {
        UpperTriangularMatrix.solveXUt(U, M, 0.0);
    }

    public static void solveUtX(FastMatrix U, FastMatrix M, double zero) throws MatrixException {
        int nr = M.getRowsCount();
        if (nr != U.getRowsCount()) {
            throw new MatrixException("m_err_dim");
        }
        DataBlockIterator cols = M.columnsIterator();
        while (cols.hasNext()) {
            DataBlock c = cols.next();
            UpperTriangularMatrix.solveUtx(U, c.getStorage(), c.getStartPosition(), 1, zero);
        }
    }

    public static void solveUtX(FastMatrix U, FastMatrix M) throws MatrixException {
        UpperTriangularMatrix.solveUtX(U, M, 0.0);
    }

    public static void Ux(FastMatrix U, DataBlock x) {
        int incx = x.getIncrement();
        if (incx == 1) {
            UpperTriangularMatrix.Ux(U, x.getStorage(), x.getStartPosition());
        } else {
            UpperTriangularMatrix.Ux(U, x.getStorage(), x.getStartPosition(), x.getIncrement());
        }
    }

    public static void xU(FastMatrix U, DataBlock x) {
        int incx = x.getIncrement();
        if (incx == 1) {
            UpperTriangularMatrix.Utx(U, x.getStorage(), x.getStartPosition());
        } else {
            UpperTriangularMatrix.Utx(U, x.getStorage(), x.getStartPosition(), x.getIncrement());
        }
    }

    public static void UM(FastMatrix U, FastMatrix M) {
        int mstart = M.getStartPosition();
        int mlda = M.getColumnIncrement();
        int n = M.getColumnsCount();
        double[] pm = M.getStorage();
        int cmax = mstart + mlda * n;
        for (int c = mstart; c < cmax; c += mlda) {
            UpperTriangularMatrix.Ux(U, pm, c);
        }
    }

    public static void MU(FastMatrix U, FastMatrix M) {
        int mstart = M.getStartPosition();
        int mlda = M.getColumnIncrement();
        int m = M.getRowsCount();
        double[] pm = M.getStorage();
        int cmax = mstart + m;
        for (int c = mstart; c < cmax; ++c) {
            UpperTriangularMatrix.Utx(U, pm, c, mlda);
        }
    }

    public static void UtM(FastMatrix U, FastMatrix M) {
        DataBlockIterator cols = M.columnsIterator();
        while (cols.hasNext()) {
            DataBlock c = cols.next();
            UpperTriangularMatrix.Utx(U, c.getStorage(), c.getStartPosition());
        }
    }

    public static void MUt(FastMatrix U, FastMatrix M) {
        DataBlockIterator rows = M.rowsIterator();
        while (rows.hasNext()) {
            DataBlock r = rows.next();
            UpperTriangularMatrix.Ux(U, r.getStorage(), r.getStartPosition(), r.getIncrement());
        }
    }

    private static void Ux(FastMatrix U, double[] px, int startx) {
        int n = U.getColumnsCount();
        int lda = U.getColumnIncrement();
        int start = U.getStartPosition();
        double[] pu = U.getStorage();
        int xend = startx + n;
        int ixj = startx;
        int u0 = start;
        while (ixj < xend) {
            double xcur = px[ixj];
            if (xcur != 0.0) {
                int iu = u0;
                int ix = startx;
                while (ix < ixj) {
                    int n2 = ix++;
                    px[n2] = px[n2] + xcur * pu[iu++];
                }
                px[ixj] = xcur * pu[iu];
            }
            ++ixj;
            u0 += lda;
        }
    }

    private static void Ux(FastMatrix U, double[] px, int startx, int incx) {
        int n = U.getColumnsCount();
        int lda = U.getColumnIncrement();
        int start = U.getStartPosition();
        double[] pu = U.getStorage();
        int xend = startx + n * incx;
        int ixj = startx;
        int u0 = start;
        while (ixj != xend) {
            double xcur = px[ixj];
            if (xcur != 0.0) {
                int iu = u0;
                for (int ix = startx; ix != ixj; ix += incx) {
                    int n2 = ix;
                    px[n2] = px[n2] + xcur * pu[iu++];
                }
                px[ixj] = xcur * pu[iu];
            }
            ixj += incx;
            u0 += lda;
        }
    }

    private static void Utx(FastMatrix U, double[] px, int startx) {
        int n = U.getColumnsCount();
        int lda = U.getColumnIncrement();
        int start = U.getStartPosition();
        double[] pu = U.getStorage();
        int xend = startx + n - 1;
        int uend = start + (n - 1) * (lda + 1);
        int u0 = uend;
        for (int ixj = xend; ixj >= startx; --ixj) {
            double tmp = px[ixj] * pu[u0--];
            int ix = ixj - 1;
            int iu = u0;
            while (ix >= startx) {
                tmp += px[ix] * pu[iu];
                --ix;
                --iu;
            }
            px[ixj] = tmp;
            u0 -= lda;
        }
    }

    private static void Utx(FastMatrix U, double[] px, int startx, int incx) {
        int n = U.getColumnsCount();
        int lda = U.getColumnIncrement();
        int start = U.getStartPosition();
        double[] pu = U.getStorage();
        int xend = startx + n * incx;
        int uend = start + (n - 1) * (lda + 1);
        int ixj = xend;
        int u0 = uend;
        while (ixj != startx) {
            double tmp = px[ixj -= incx] * pu[u0--];
            int iu = u0;
            int ix = ixj;
            while (ix != startx) {
                tmp += px[ix -= incx] * pu[iu--];
            }
            px[ixj] = tmp;
            u0 -= lda;
        }
    }

    public static void solveUtx(FastMatrix U, double[] px, int startx, int incx, double zero) {
        int n = U.getColumnsCount();
        int lda = U.getColumnIncrement();
        int start = U.getStartPosition();
        double[] pu = U.getStorage();
        if (incx == 1) {
            int xend = startx + n;
            int ix = startx;
            int il = start;
            while (ix < xend) {
                double t = px[ix];
                int jl = il;
                int jx = startx;
                while (jx < ix) {
                    t -= px[jx] * pu[jl];
                    ++jx;
                    ++jl;
                }
                double d = pu[jl];
                if (Math.abs(d) <= zero) {
                    if (Math.abs(t) >= zero) {
                        throw new MatrixException("m_err_sing");
                    }
                    px[ix] = 0.0;
                } else {
                    px[ix] = t / d;
                }
                ++ix;
                il += lda;
            }
        } else {
            int xend = startx + n * incx;
            int ix = startx;
            int il = start;
            while (ix < xend) {
                double t = px[ix];
                int jl = il;
                int jx = startx;
                while (jx < ix) {
                    t -= px[jx] * pu[jl];
                    jx += incx;
                    ++jl;
                }
                double d = pu[jl];
                if (Math.abs(d) <= zero) {
                    if (Math.abs(t) >= zero) {
                        throw new MatrixException("m_err_sing");
                    }
                    px[ix] = 0.0;
                } else {
                    px[ix] = t / d;
                }
                ix += incx;
                il += lda;
            }
        }
    }

    public static void solveUx(FastMatrix U, double[] px, int startx, int incx, double zero) {
        int n = U.getColumnsCount();
        int lda = U.getColumnIncrement();
        int start = U.getStartPosition();
        double[] pu = U.getStorage();
        if (incx == 1) {
            int xend;
            int jx = xend = startx + n - 1;
            int ju = start + (n - 1) * (lda + 1);
            while (jx >= startx) {
                double t = px[jx];
                double d = pu[ju];
                if (Math.abs(d) <= zero) {
                    if (Math.abs(t) >= zero) {
                        throw new MatrixException("m_err_sing");
                    }
                    px[jx] = 0.0;
                } else {
                    double c;
                    px[jx] = c = t / d;
                    int ix = jx - 1;
                    int il = ju - 1;
                    while (ix >= startx) {
                        int n2 = ix--;
                        px[n2] = px[n2] - c * pu[il];
                        --il;
                    }
                }
                --jx;
                ju -= lda + 1;
            }
        } else {
            int xend;
            int jx = xend = startx + n * incx;
            int ju = start + (n - 1) * (lda + 1);
            while (jx != startx) {
                double t = px[jx -= incx];
                double d = pu[ju];
                if (Math.abs(d) <= zero) {
                    if (Math.abs(t) >= zero) {
                        throw new MatrixException("m_err_sing");
                    }
                    px[jx] = 0.0;
                } else {
                    double c;
                    px[jx] = c = t / d;
                    int ix = jx;
                    int il = ju - 1;
                    while (ix != startx) {
                        int n3 = ix -= incx;
                        px[n3] = px[n3] - c * pu[il];
                        --il;
                    }
                }
                ju -= lda + 1;
            }
        }
    }

    public static void toUpper(FastMatrix M) {
        int n;
        int m = M.getRowsCount();
        if (m != (n = M.getColumnsCount())) {
            throw new MatrixException("m_err_square");
        }
        if (n == 1) {
            return;
        }
        double[] x = M.getStorage();
        int lda = M.getColumnIncrement();
        int start = M.getStartPosition();
        int id = start + 1;
        for (int c = n - 1; c > 0; --c) {
            int imax = id + c;
            for (int iu = id; iu < imax; ++iu) {
                x[iu] = 0.0;
            }
            id += lda + 1;
        }
    }

    public static FastMatrix inverse(FastMatrix U) throws MatrixException {
        if (U.diagonal().anyMatch(x -> x == 0.0)) {
            throw new MatrixException("m_err_sing");
        }
        int n = U.getRowsCount();
        if (n != U.getColumnsCount()) {
            throw new MatrixException("m_err_square");
        }
        FastMatrix IU = FastMatrix.identity(n);
        UpperTriangularMatrix.solveUX(U, IU);
        return IU;
    }

    public static LogSign logDeterminant(FastMatrix U) {
        return LogSign.of((DoubleSeq)U.diagonal());
    }

    public static double determinant(FastMatrix U) {
        LogSign ls = UpperTriangularMatrix.logDeterminant(U);
        if (ls == null) {
            return 0.0;
        }
        double val = Math.exp(ls.getValue());
        return ls.isPositive() ? val : -val;
    }

    @Generated
    private UpperTriangularMatrix() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

