/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.decomposition;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.decomposition.IVectorTransformation;

public class HyperbolicHouseholderReflection
implements IVectorTransformation {
    private final int pos;
    private double beta;
    private double mu;
    private DataBlock vector;

    private HyperbolicHouseholderReflection(int pos) {
        this.pos = pos;
    }

    public static HyperbolicHouseholderReflection of(DataBlock v, int pos) {
        HyperbolicHouseholderReflection reflection = new HyperbolicHouseholderReflection(pos);
        reflection.householder(v);
        return reflection;
    }

    public static HyperbolicHouseholderReflection inPlace(DataBlock v, int pos) {
        HyperbolicHouseholderReflection reflection = new HyperbolicHouseholderReflection(pos);
        reflection.vector = v;
        reflection.inPlaceHouseholder();
        return reflection;
    }

    public DataBlock getHouseholderVector() {
        return this.vector;
    }

    public double getNrm2() {
        return this.mu;
    }

    public double getBeta() {
        return this.beta;
    }

    private void householder(DataBlock x) {
        int n = x.length();
        if (n == 1) {
            x.set(0, Math.abs(x.get(0)));
            return;
        }
        this.vector = DataBlock.of((DoubleSeq)x);
        this.inPlaceHouseholder();
        x.set(() -> 0.0);
        x.set(0, this.mu);
    }

    private void inPlaceHouseholder() {
        int i;
        int n = this.vector.length();
        if (n == 1) {
            return;
        }
        double[] v = this.vector.getStorage();
        int beg = this.vector.getStartPosition();
        int end = this.vector.getEndPosition();
        int inc = this.vector.getIncrement();
        int pend = beg + inc * this.pos;
        double sigp = 0.0;
        double sign = 0.0;
        for (i = beg + inc; i != pend; i += inc) {
            sigp += v[i] * v[i];
        }
        for (i = pend; i != end; i += inc) {
            sign += v[i] * v[i];
        }
        if (sigp < Constants.getEpsilon() && sign < Constants.getEpsilon()) {
            return;
        }
        double x0 = v[beg];
        double sig = x0 * x0 + sigp - sign;
        this.mu = Math.sqrt(sig);
        double v0 = x0 <= 0.0 ? x0 - this.mu : -sig / (x0 + this.mu);
        this.beta = 2.0 / (sig + v0 * v0);
        v[beg] = v0;
    }

    @Override
    public void transform(DataBlock y) {
        if (this.beta == 0.0) {
            return;
        }
        double vy = y.jdot(this.vector, this.pos);
        y.addAY(-this.beta * vy, this.vector);
    }
}

