/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.polynomials;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class JacobiPolynomials {
    private static final Map<Key, List<double[]>> MAP = new HashMap<Key, List<double[]>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Polynomial jacobi(int degree, double a, double b) {
        Map<Key, List<double[]>> map = MAP;
        synchronized (map) {
            Key key = new Key(a, b);
            List<double[]> p = MAP.get(key);
            if (p == null) {
                p = new ArrayList<double[]>();
                p.add(new double[]{1.0});
                p.add(new double[]{key.diff() / 2.0, 1.0 + key.sum() / 2.0});
                MAP.put(key, p);
            }
            if (p.size() > degree) {
                return Polynomial.ofInternal(p.get(degree));
            }
            for (int k = p.size(); k <= degree; ++k) {
                int i;
                Polynomial p1 = Polynomial.ofInternal(p.get(k - 1));
                double ck = key.c(k);
                double c2k = key.c(2 * k);
                double c2km1 = key.c(2 * k - 1);
                double c2km2 = key.c(2 * k - 2);
                double p11 = c2k * c2km1 * c2km2;
                double p10 = c2km1 * (a * a - b * b);
                p1 = p1.times(Polynomial.of(p10, p11));
                double[] pk = p1.toArray();
                double q = -2.0 * ((double)(k - 1) + a) * ((double)(k - 1) + b) * c2k;
                double[] pkm2 = p.get(k - 2);
                double d = (double)(2 * k) * ck * c2km2;
                for (i = 0; i < pkm2.length; ++i) {
                    pk[i] = (pk[i] + q * pkm2[i]) / d;
                }
                i = pkm2.length;
                while (i < pk.length) {
                    int n = i++;
                    pk[n] = pk[n] / d;
                }
                p.add(pk);
            }
            return Polynomial.ofInternal(p.get(degree));
        }
    }

    @Generated
    private JacobiPolynomials() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class Key
    implements Comparable<Key> {
        private final double a;
        private final double b;

        @Override
        public int compareTo(Key t) {
            if (this.a < t.a) {
                return -1;
            }
            if (this.a > t.a) {
                return 1;
            }
            if (this.b < t.b) {
                return -1;
            }
            if (this.b > t.b) {
                return 1;
            }
            return 0;
        }

        double diff() {
            return this.a - this.b;
        }

        double sum() {
            return this.a + this.b;
        }

        double c(int n) {
            return (double)n + this.a + this.b;
        }

        @Generated
        public Key(double a, double b) {
            this.a = a;
            this.b = b;
        }

        @Generated
        public double getA() {
            return this.a;
        }

        @Generated
        public double getB() {
            return this.b;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            if (Double.compare(this.getA(), other.getA()) != 0) {
                return false;
            }
            return Double.compare(this.getB(), other.getB()) == 0;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $a = Double.doubleToLongBits(this.getA());
            result = result * 59 + (int)($a >>> 32 ^ $a);
            long $b = Double.doubleToLongBits(this.getB());
            result = result * 59 + (int)($b >>> 32 ^ $b);
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "JacobiPolynomials.Key(a=" + this.getA() + ", b=" + this.getB() + ")";
        }
    }
}

