/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regular.tests;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.analysis.AutoRegressiveSpectrum;
import jdplus.toolkit.base.core.data.analysis.Periodogram;
import jdplus.toolkit.base.core.stats.DescriptiveStatistics;

public class SpectralAnalysis {
    private double[] svals;
    private double[] freqs;
    private int[] seasfreq;
    private int[] tdfreq;
    private double threshold;
    private double median;

    public static Builder test(TsData s) {
        return new Builder(s);
    }

    public double getFrequency(int i) {
        return this.freqs[i];
    }

    public double getSpectrumValue(int i) {
        return this.svals[i];
    }

    public int[] getSeasonalFrequencies() {
        return this.seasfreq;
    }

    public int[] getTradingDaysFrequencies() {
        return this.tdfreq;
    }

    public boolean hasTradingDayPeaks() {
        if (this.tdfreq == null) {
            return false;
        }
        for (int i = 0; i < this.tdfreq.length; ++i) {
            if (!this.isSignificant(this.tdfreq[i])) continue;
            return true;
        }
        return false;
    }

    public boolean hasSeasonalPeaks() {
        if (this.seasfreq == null) {
            return false;
        }
        for (int i = 0; i < this.seasfreq.length; ++i) {
            if (!this.isSignificant(this.seasfreq[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isSignificant(int idx) {
        if (this.svals[idx] < this.median) {
            return false;
        }
        if (idx == 0) {
            return this.svals[idx] - this.svals[idx + 1] > this.threshold;
        }
        if (idx == this.svals.length - 1) {
            return this.svals[idx] - this.svals[idx - 1] > this.threshold;
        }
        return this.svals[idx] - this.svals[idx - 1] > this.threshold && this.svals[idx] - this.svals[idx + 1] > this.threshold;
    }

    public static class Builder {
        private final TsData s;
        private int nar = 30;
        private int npoints = 60;
        private double sensibility = 0.11538461538461539;

        Builder(TsData s) {
            this.s = s;
        }

        public Builder arLength(int nar) {
            this.nar = nar;
            return this;
        }

        public Builder sensibility(double sensibility) {
            this.sensibility = sensibility;
            return this;
        }

        public Builder resolution(int npoints) {
            this.npoints = npoints;
            return this;
        }

        public SpectralAnalysis build() {
            try {
                AutoRegressiveSpectrum ars = new AutoRegressiveSpectrum(AutoRegressiveSpectrum.Method.Ols);
                int freq = this.s.getAnnualFrequency();
                double[] dtdfreq = Periodogram.getTradingDaysFrequencies(freq);
                int nsf = freq >= 4 ? (freq - 1) / 2 : freq / 2;
                int[] seasfreq = new int[nsf];
                int iseas = 2 * this.npoints / freq;
                for (int i = 0; i < seasfreq.length; ++i) {
                    seasfreq[i] = iseas * (i + 1);
                }
                double[] freqs = new double[this.npoints + 1];
                double fstep = Math.PI / (double)this.npoints;
                for (int i = 0; i <= this.npoints; ++i) {
                    freqs[i] = fstep * (double)i;
                }
                int[] tdfreq = null;
                if (dtdfreq != null) {
                    tdfreq = new int[dtdfreq.length];
                    block4: for (int i = 0; i < tdfreq.length; ++i) {
                        for (int j = 0; j < this.npoints; ++j) {
                            if (!(dtdfreq[i] > freqs[j]) || !(dtdfreq[i] <= freqs[j + 1])) continue;
                            double d0 = dtdfreq[i] - freqs[j];
                            double d1 = freqs[j + 1] - dtdfreq[i];
                            if (d0 < d1) {
                                freqs[j] = dtdfreq[i];
                                tdfreq[i] = j;
                                continue block4;
                            }
                            freqs[j + 1] = dtdfreq[i];
                            tdfreq[i] = j + 1;
                            continue block4;
                        }
                    }
                }
                double median = 0.0;
                double srange = 0.0;
                double[] svals = null;
                if (ars.process(this.s.getValues(), this.nar)) {
                    svals = new double[this.npoints + 1];
                    for (int i = 0; i < freqs.length; ++i) {
                        svals[i] = ars.value(freqs[i]);
                    }
                    DescriptiveStatistics stats = DescriptiveStatistics.of((DoubleSeq)DataBlock.of(svals).drop(1, 1));
                    median = stats.getMedian();
                    srange = stats.getMax() - stats.getMin();
                }
                SpectralAnalysis rslt = new SpectralAnalysis();
                rslt.svals = svals;
                rslt.median = median;
                rslt.freqs = freqs;
                rslt.seasfreq = seasfreq;
                rslt.tdfreq = tdfreq;
                rslt.threshold = srange * this.sensibility;
                return rslt;
            }
            catch (Exception ex) {
                return null;
            }
        }
    }
}

