/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.diagnostics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.processing.Diagnostics;
import jdplus.toolkit.base.api.processing.ProcQuality;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.core.data.analysis.Periodogram;
import jdplus.toolkit.base.core.regarima.diagnostics.RegArimaDiagnostics;
import jdplus.toolkit.base.core.regarima.diagnostics.ResidualsDiagnosticsConfiguration;
import jdplus.toolkit.base.core.regarima.diagnostics.ResidualsDiagnosticsFactory;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;
import jdplus.toolkit.base.core.stats.tests.NiidTests;

public class ResidualsDiagnostics
implements Diagnostics {
    private double N0 = 0.1;
    private double N1 = 0.01;
    private double tdPeriodogram0 = 0.1;
    private double tdPeriodogram1 = 0.01;
    private double tdPeriodogram2 = 0.001;
    private double sPeriodogram0 = 0.1;
    private double sPeriodogram1 = 0.01;
    private double sPeriodogram2 = 0.001;
    private final List<String> warnings = new ArrayList<String>();
    private NiidTests stats;
    private Periodogram periodogram;
    private int period;

    static ResidualsDiagnostics create(ResidualsDiagnosticsConfiguration config, RegSarimaModel regarima) {
        try {
            if (regarima == null) {
                return null;
            }
            return new ResidualsDiagnostics(config, regarima);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public ResidualsDiagnostics(ResidualsDiagnosticsConfiguration config, RegSarimaModel rslts) {
        this.sPeriodogram2 = config.getSevereThresholdForSeasonalPeaks();
        this.sPeriodogram1 = config.getBadThresholdForSeasonalPeaks();
        this.sPeriodogram0 = config.getUncertainThresholdForSeasonalPeaks();
        this.tdPeriodogram2 = config.getSevereThresholdForTradingDaysPeak();
        this.tdPeriodogram1 = config.getBadThresholdForTradingDaysPeak();
        this.tdPeriodogram0 = config.getUncertainThresholdForTradingDaysPeak();
        this.N0 = config.getUncertainThresholdForNormality();
        this.N1 = config.getBadThresholdForNormality();
        this.testRegarima(rslts);
    }

    private boolean testRegarima(RegSarimaModel regarima) {
        try {
            DoubleSeq res = regarima.fullResiduals().getValues();
            this.period = regarima.getAnnualFrequency();
            this.stats = RegArimaDiagnostics.residualTests(res, this.period, regarima.freeArimaParametersCount());
            this.periodogram = Periodogram.of(res);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public String getName() {
        return "Regarima residuals";
    }

    public List<String> getTests() {
        return ResidualsDiagnosticsFactory.ALL;
    }

    public ProcQuality getDiagnostic(String test) {
        switch (test) {
            case "normality": {
                if (this.stats == null) {
                    return ProcQuality.Undefined;
                }
                StatisticalTest dht = this.stats.normalityTest();
                if (dht == null) {
                    return ProcQuality.Undefined;
                }
                double pval = dht.getPvalue();
                if (pval > this.N0) {
                    return ProcQuality.Good;
                }
                if (pval < this.N1) {
                    return ProcQuality.Bad;
                }
                return ProcQuality.Uncertain;
            }
            case "independence": {
                if (this.stats == null) {
                    return ProcQuality.Undefined;
                }
                StatisticalTest lbt = this.stats.ljungBox();
                if (lbt == null) {
                    return ProcQuality.Undefined;
                }
                double pval = lbt.getPvalue();
                if (pval > this.N0) {
                    return ProcQuality.Good;
                }
                if (pval < this.N1) {
                    return ProcQuality.Bad;
                }
                return ProcQuality.Uncertain;
            }
            case "spectral td peaks": {
                if (this.periodogram == null || this.period == 4) {
                    return ProcQuality.Undefined;
                }
                double[] tdfreqs = Periodogram.getTradingDaysFrequencies(this.period);
                double[] p = this.periodogram.getP();
                double xmax = 0.0;
                double dstep = this.periodogram.getIntervalInRadians();
                for (int i = 0; i < tdfreqs.length; ++i) {
                    int i0 = (int)(tdfreqs[i] / dstep);
                    double xcur = p[i0];
                    if (xcur > xmax) {
                        xmax = xcur;
                    }
                    if (!((xcur = p[i0 + 1]) > xmax)) continue;
                    xmax = xcur;
                }
                double pval = 1.0 - Math.pow(1.0 - Math.exp(-xmax * 0.5), tdfreqs.length);
                if (pval < this.tdPeriodogram2) {
                    return ProcQuality.Severe;
                }
                if (pval < this.tdPeriodogram1) {
                    return ProcQuality.Bad;
                }
                if (pval > this.tdPeriodogram0) {
                    return ProcQuality.Good;
                }
                return ProcQuality.Uncertain;
            }
            case "spectral seas peaks": {
                if (this.periodogram == null) {
                    return ProcQuality.Undefined;
                }
                double[] seasfreqs = new double[(this.period - 1) / 2];
                for (int i = 0; i < seasfreqs.length; ++i) {
                    seasfreqs[i] = (double)((i + 1) * 2) * Math.PI / (double)this.period;
                }
                double[] p = this.periodogram.getP();
                double xmax = 0.0;
                double dstep = this.periodogram.getIntervalInRadians();
                for (int i = 0; i < seasfreqs.length; ++i) {
                    int i0 = (int)(seasfreqs[i] / dstep);
                    double xcur = p[i0];
                    if (xcur > xmax) {
                        xmax = xcur;
                    }
                    if (!((xcur = p[i0 + 1]) > xmax)) continue;
                    xmax = xcur;
                }
                double pval = 1.0 - Math.pow(1.0 - Math.exp(-xmax * 0.5), seasfreqs.length);
                if (pval < this.sPeriodogram2) {
                    return ProcQuality.Severe;
                }
                if (pval < this.sPeriodogram1) {
                    return ProcQuality.Bad;
                }
                if (pval > this.sPeriodogram0) {
                    return ProcQuality.Good;
                }
                return ProcQuality.Uncertain;
            }
        }
        return ProcQuality.Undefined;
    }

    public double getValue(String test) {
        try {
            double pval = 0.0;
            switch (test) {
                case "normality": {
                    if (this.stats == null) break;
                    StatisticalTest dht = this.stats.normalityTest();
                    pval = dht.getPvalue();
                    break;
                }
                case "independence": {
                    if (this.stats == null) break;
                    StatisticalTest lbt = this.stats.ljungBox();
                    pval = lbt.getPvalue();
                    break;
                }
                case "spectral td peaks": {
                    if (this.periodogram == null || this.period == 4) break;
                    double[] tdfreqs = Periodogram.getTradingDaysFrequencies(this.period);
                    double[] p = this.periodogram.getP();
                    double xmax = 0.0;
                    double dstep = this.periodogram.getIntervalInRadians();
                    for (int i = 0; i < tdfreqs.length; ++i) {
                        int i0 = (int)(tdfreqs[i] / dstep);
                        double xcur = p[i0];
                        if (xcur > xmax) {
                            xmax = xcur;
                        }
                        if (!((xcur = p[i0 + 1]) > xmax)) continue;
                        xmax = xcur;
                    }
                    pval = 1.0 - Math.pow(1.0 - Math.exp(-xmax * 0.5), tdfreqs.length);
                    break;
                }
                case "spectral seas peaks": {
                    if (this.periodogram == null) break;
                    double[] seasfreqs = new double[(this.period - 1) / 2];
                    for (int i = 0; i < seasfreqs.length; ++i) {
                        seasfreqs[i] = (double)((i + 1) * 2) * Math.PI / (double)this.period;
                    }
                    double[] p = this.periodogram.getP();
                    double xmax = 0.0;
                    double dstep = this.periodogram.getIntervalInRadians();
                    for (int i = 0; i < seasfreqs.length; ++i) {
                        int i0 = (int)(seasfreqs[i] / dstep);
                        double xcur = p[i0];
                        if (xcur > xmax) {
                            xmax = xcur;
                        }
                        if (!((xcur = p[i0 + 1]) > xmax)) continue;
                        xmax = xcur;
                    }
                    pval = 1.0 - Math.pow(1.0 - Math.exp(-xmax * 0.5), seasfreqs.length);
                    break;
                }
            }
            return pval;
        }
        catch (Exception err) {
            return Double.NaN;
        }
    }

    public List<String> getWarnings() {
        return Collections.emptyList();
    }

    public double getNIIDBound(ProcQuality quality) {
        switch (quality) {
            case Bad: {
                return this.N1;
            }
            case Uncertain: {
                return this.N0;
            }
        }
        return Double.NaN;
    }

    public double getTDPeriodogram(ProcQuality quality) {
        switch (quality) {
            case Severe: {
                return this.tdPeriodogram2;
            }
            case Bad: {
                return this.tdPeriodogram1;
            }
            case Uncertain: {
                return this.tdPeriodogram0;
            }
        }
        return Double.NaN;
    }

    public double getSPeriodogram(ProcQuality quality) {
        switch (quality) {
            case Severe: {
                return this.sPeriodogram2;
            }
            case Bad: {
                return this.sPeriodogram1;
            }
            case Uncertain: {
                return this.sPeriodogram0;
            }
        }
        return Double.NaN;
    }
}

