/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regsarima.regular;

import jdplus.toolkit.base.core.regsarima.regular.IRegressionTest;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;

public class TRegressionTest
implements IRegressionTest {
    private final double tlow;
    private final double thigh;
    private final int nsig;

    public TRegressionTest(double tlow, double thigh) {
        this.tlow = tlow;
        this.thigh = thigh;
        this.nsig = 2;
    }

    public TRegressionTest(double tsig) {
        this.tlow = tsig;
        this.thigh = tsig;
        this.nsig = 1;
    }

    @Override
    public boolean accept(ConcentratedLikelihoodWithMissing ll, int nhp, int ireg, int nregs) {
        double[] t = ll.tstats(nhp < 0 ? 0 : nhp, nhp >= 0);
        int nlow = 0;
        int nhigh = 0;
        for (int i = 0; i < nregs; ++i) {
            double ct = Math.abs(t[ireg + i]);
            if (ct >= this.thigh) {
                ++nhigh;
                continue;
            }
            if (!(ct >= this.tlow)) continue;
            ++nlow;
        }
        return nhigh > 0 || nlow >= Math.min(this.nsig, nregs);
    }
}

