/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.univariate;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.QuadraticForm;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.ResultsRange;
import jdplus.toolkit.base.core.ssf.State;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.univariate.DefaultFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.DefaultSmoothingResults;
import jdplus.toolkit.base.core.ssf.univariate.ISmoothingResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.OrdinaryFilter;

public class OrdinarySmoother {
    private final ISsf ssf;
    private final ISsfDynamics dynamics;
    private final ISsfLoading loading;
    private final boolean calcvar;
    private State state;
    private ISmoothingResults srslts;
    private DefaultFilteringResults frslts;
    private double err;
    private double errVariance;
    private double u;
    private double uVariance;
    private DataBlock M;
    private DataBlock R;
    private FastMatrix N;
    private boolean missing;
    private int stop;

    public static Builder builder(ISsf ssf) {
        return new Builder(ssf);
    }

    public OrdinarySmoother(ISsf ssf, boolean calcvar) {
        this.ssf = ssf;
        this.calcvar = calcvar;
        this.dynamics = ssf.dynamics();
        this.loading = ssf.loading();
    }

    public boolean process(ISsfData data) {
        if (this.ssf.initialization().isDiffuse()) {
            return false;
        }
        OrdinaryFilter filter = new OrdinaryFilter();
        DefaultFilteringResults fresults = DefaultFilteringResults.full();
        if (!filter.process(this.ssf, data, fresults)) {
            return false;
        }
        return this.process(0, data.length(), fresults);
    }

    public boolean process(DefaultFilteringResults results) {
        if (this.ssf.initialization().isDiffuse()) {
            return false;
        }
        ResultsRange range = results.getRange();
        return this.process(range.getStart(), range.getEnd(), results);
    }

    public boolean process(int start, int end, DefaultFilteringResults results) {
        DefaultSmoothingResults sresults = this.calcvar ? DefaultSmoothingResults.full() : DefaultSmoothingResults.light();
        return this.process(start, end, results, sresults);
    }

    public boolean process(int start, int end, DefaultFilteringResults results, ISmoothingResults sresults) {
        this.frslts = results;
        this.srslts = sresults;
        this.stop = start;
        this.initSmoother(this.ssf);
        int t = end;
        while (--t >= this.stop) {
            this.loadInfo(t);
            if (!this.iterate(t)) continue;
            this.srslts.save(t, this.state, StateInfo.Smoothed);
        }
        return true;
    }

    public ISmoothingResults getResults() {
        return this.srslts;
    }

    public DataBlock getFinalR() {
        return this.R;
    }

    public FastMatrix getFinalN() {
        return this.N;
    }

    public double getFinalSmoothation() {
        return this.u;
    }

    public double getFinalSmoothationVariance() {
        return this.uVariance;
    }

    private void initSmoother(ISsf ssf) {
        int dim = ssf.getStateDim();
        this.state = new State(dim);
        this.R = DataBlock.make(dim);
        this.M = DataBlock.make(dim);
        if (this.calcvar) {
            this.N = FastMatrix.square(dim);
        }
    }

    private void loadInfo(int pos) {
        this.err = this.frslts.error(pos);
        this.errVariance = this.frslts.errorVariance(pos);
        this.M.copy(this.frslts.M(pos));
        this.missing = !Double.isFinite(this.err);
    }

    private boolean iterate(int pos) {
        this.iterateSmoothation(pos);
        this.iterateR(pos);
        if (this.calcvar) {
            this.iterateN(pos);
        }
        this.srslts.saveSmoothation(pos, this.u, this.uVariance);
        this.srslts.saveR(pos, this.R, this.N);
        DataBlock fa = this.frslts.a(pos);
        FastMatrix fP = this.frslts.P(pos);
        if (fP == null) {
            return false;
        }
        DataBlock a = this.state.a();
        a.copy(fa);
        a.addProduct(this.R, fP.columnsIterator());
        if (this.calcvar) {
            FastMatrix P = this.state.P();
            P.copy(fP);
            FastMatrix V = SymmetricMatrix.XtSX(this.N, P);
            P.sub(V);
        }
        return true;
    }

    private void iterateSmoothation(int pos) {
        if (this.missing) {
            this.u = Double.NaN;
            this.uVariance = Double.NaN;
            return;
        }
        DataBlock k = this.M.deepClone();
        this.dynamics.TX(pos, k);
        k.div(this.errVariance);
        if (this.errVariance != 0.0) {
            this.u = this.err / this.errVariance - this.R.dot(k);
            if (this.calcvar) {
                this.uVariance = 1.0 / this.errVariance + QuadraticForm.apply(this.N, k);
                if (this.uVariance < 1.0E-9) {
                    this.uVariance = 0.0;
                }
            }
        } else {
            this.u = 0.0;
            this.uVariance = 0.0;
        }
    }

    private void iterateN(int pos) {
        if (!this.missing && this.errVariance != 0.0) {
            this.ssf.XL(pos, this.N, this.M, this.errVariance);
            this.ssf.XtL(pos, this.N, this.M, this.errVariance);
            this.loading.VpZdZ(pos, this.N, 1.0 / this.errVariance);
        } else {
            this.dynamics.MT(pos, this.N);
            this.dynamics.TtM(pos, this.N);
        }
        SymmetricMatrix.reenforceSymmetry(this.N);
        this.N.apply(z -> Math.abs(z) < 1.0E-9 ? 0.0 : z);
    }

    private void iterateR(int pos) {
        this.dynamics.XT(pos, this.R);
        if (!this.missing && this.u != 0.0) {
            this.loading.XpZd(pos, this.R, this.u);
        }
        this.R.apply(z -> Math.abs(z) < 1.0E-9 ? 0.0 : z);
    }

    public static class Builder {
        private final ISsf ssf;
        private boolean rescaleVariance = false;
        private boolean calcVariance = true;

        public Builder(ISsf ssf) {
            this.ssf = ssf;
        }

        public Builder calcVariance(boolean calc) {
            this.calcVariance = calc;
            if (!calc) {
                this.rescaleVariance = false;
            }
            return this;
        }

        public OrdinarySmoother build() {
            return new OrdinarySmoother(this.ssf, this.calcVariance);
        }
    }
}

