/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ucarima;

import java.util.ArrayList;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.math.ComplexUtility;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.ucarima.IRootSelector;

public abstract class AbstractRootSelector
implements IRootSelector {
    protected Polynomial selected;
    protected Polynomial notSelected;

    public abstract boolean accept(Complex var1);

    @Override
    public Polynomial getOutofSelection() {
        return this.notSelected;
    }

    @Override
    public Polynomial getSelection() {
        return this.selected;
    }

    @Override
    public boolean select(Polynomial p) {
        if (p.degree() == 0) {
            this.notSelected = p;
            this.selected = null;
            return false;
        }
        Complex[] roots = p.roots();
        ArrayList<Complex> sel = new ArrayList<Complex>();
        ArrayList<Complex> nsel = new ArrayList<Complex>();
        for (int i = 0; i < roots.length; ++i) {
            if (this.accept(roots[i])) {
                sel.add(roots[i]);
                continue;
            }
            nsel.add(roots[i]);
        }
        if (sel.isEmpty()) {
            this.selected = null;
            this.notSelected = p;
            return false;
        }
        if (nsel.isEmpty()) {
            this.notSelected = null;
            this.selected = p;
            return true;
        }
        Complex[] rs = sel.toArray(new Complex[sel.size()]);
        Complex[] rn = nsel.toArray(new Complex[nsel.size()]);
        ComplexUtility.lejaOrder(rs);
        ComplexUtility.lejaOrder(rn);
        this.selected = Polynomial.fromComplexRoots(rs);
        this.selected = this.selected.times(p.get(0) / this.selected.get(0));
        this.notSelected = Polynomial.fromComplexRoots(rn);
        this.notSelected = this.notSelected.divide(this.notSelected.get(0));
        return true;
    }
}

