/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.operations;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.ohdsi.circe.check.operations.ConditionalOperations;
import org.ohdsi.circe.check.operations.Execution;
import org.ohdsi.circe.check.operations.ExecutiveOperations;

public class Operations<T, V>
implements ConditionalOperations<T, V>,
ExecutiveOperations<T, V> {
    private Boolean result;
    private final T value;
    private V returnValue;

    private Operations(T value) {
        this.value = value;
    }

    public static <T, V> ConditionalOperations<T, V> match(T value) {
        return new Operations<T, V>(value);
    }

    @Override
    public ExecutiveOperations<T, V> when(Function<T, Boolean> condition) {
        this.result = Objects.nonNull(this.value) && condition.apply(this.value) != false;
        return this;
    }

    @Override
    public ExecutiveOperations<T, V> isA(Class<?> clazz) {
        this.result = Objects.nonNull(clazz) && Objects.nonNull(this.value) && clazz.isAssignableFrom(this.value.getClass());
        return this;
    }

    @Override
    public ConditionalOperations<T, V> then(Consumer<T> consumer) {
        if (this.result.booleanValue()) {
            consumer.accept(this.value);
        }
        return this;
    }

    @Override
    public ConditionalOperations<T, V> then(Execution execution) {
        if (this.result.booleanValue()) {
            execution.apply();
        }
        return this;
    }

    @Override
    public ConditionalOperations<T, V> thenReturn(Function<T, V> function) {
        if (this.result.booleanValue()) {
            this.returnValue = function.apply(this.value);
        }
        return this;
    }

    @Override
    public void orElse(Consumer<T> consumer) {
        if (!this.result.booleanValue()) {
            consumer.accept(this.value);
        }
    }

    @Override
    public V value() {
        return this.returnValue;
    }
}

