/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.ohdsi.sql.StringUtils;

public class SqlRender {
    private static List<Span> findCurlyBracketSpans(String str) {
        Stack<Integer> starts = new Stack<Integer>();
        ArrayList<Span> spans = new ArrayList<Span>();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '{') {
                starts.push(i);
                continue;
            }
            if (str.charAt(i) != '}' || starts.empty()) continue;
            spans.add(new Span((Integer)starts.pop(), i + 1));
        }
        return spans;
    }

    private static List<Span> findParentheses(String str) {
        Stack<Integer> starts = new Stack<Integer>();
        ArrayList<Span> spans = new ArrayList<Span>();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '(') {
                starts.push(i);
                continue;
            }
            if (str.charAt(i) != ')' || starts.empty()) continue;
            spans.add(new Span((Integer)starts.pop(), i + 1));
        }
        return spans;
    }

    private static List<IfThenElse> linkIfThenElses(String str, List<Span> spans) {
        ArrayList<IfThenElse> ifThenElses = new ArrayList<IfThenElse>();
        if (spans.size() > 1) {
            for (int i = 0; i < spans.size() - 1; ++i) {
                for (int j = i + 1; j < spans.size(); ++j) {
                    if (spans.get((int)j).start <= spans.get((int)i).end) continue;
                    String inBetween = str.substring(spans.get((int)i).end, spans.get((int)j).start);
                    if (!(inBetween = inBetween.trim()).equals("?")) continue;
                    IfThenElse ifThenElse = new IfThenElse();
                    ifThenElse.condition = spans.get(i);
                    ifThenElse.ifTrue = spans.get(j);
                    if (j < spans.size()) {
                        for (int k = j + 1; k < spans.size(); ++k) {
                            if (spans.get((int)k).start <= spans.get((int)j).end) continue;
                            inBetween = str.substring(spans.get((int)j).end, spans.get((int)k).start);
                            if (!(inBetween = inBetween.trim()).equals(":")) continue;
                            ifThenElse.ifFalse = spans.get(k);
                            ifThenElse.hasIfFalse = true;
                        }
                    }
                    ifThenElses.add(ifThenElse);
                }
            }
        }
        return ifThenElses;
    }

    private static boolean evaluateCondition(String str) {
        str = str.trim();
        List<Span> spans = SqlRender.findParentheses(str);
        for (Span span : spans) {
            if (SqlRender.precededByIn(span.start, str)) continue;
            boolean evaluation = SqlRender.evaluateBooleanCondition(str.substring(span.start + 1, span.end - 1));
            str = StringUtils.replaceCharAt(str, span.start, evaluation ? (char)'1' : '0');
            str = SqlRender.replace(str, spans, span.start, span.end, span.start, span.start);
        }
        return SqlRender.evaluateBooleanCondition(str);
    }

    private static boolean evaluateBooleanCondition(String str) {
        int found = (str = str.trim()).indexOf("&");
        if (found != -1) {
            String[] parts;
            for (String part : parts = str.split("&")) {
                if (SqlRender.evaluatePrimitiveCondition(part)) continue;
                return false;
            }
            return true;
        }
        found = str.indexOf("|");
        if (found != -1) {
            String[] parts;
            for (String part : parts = str.split("\\|")) {
                if (!SqlRender.evaluatePrimitiveCondition(part)) continue;
                return true;
            }
            return false;
        }
        return SqlRender.evaluatePrimitiveCondition(str);
    }

    private static boolean precededByIn(int start, String str) {
        str = str.toLowerCase();
        int matched = 0;
        for (int i = start - 1; i >= 0; --i) {
            if (!Character.isWhitespace(str.charAt(i))) {
                if (matched == 0 && str.charAt(i) == 'n') {
                    ++matched;
                    continue;
                }
                if (matched == 1 && str.charAt(i) == 'i') {
                    ++matched;
                    continue;
                }
                return false;
            }
            if (matched != 2) continue;
            return true;
        }
        return false;
    }

    private static String removeParentheses(String s) {
        if (s.length() > 1 && (s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'' || s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"')) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private static boolean evaluatePrimitiveCondition(String str) {
        String str_lc = (str = str.trim()).toLowerCase();
        if (str_lc.equals("false") || str_lc.equals("0") || str_lc.equals("!true") || str_lc.equals("!1")) {
            return false;
        }
        if (str_lc.equals("true") || str_lc.equals("1") || str_lc.equals("!false") || str_lc.equals("!0")) {
            return true;
        }
        int found = str.indexOf("==");
        if (found != -1) {
            String left = str.substring(0, found);
            left = left.trim();
            left = SqlRender.removeParentheses(left);
            String right = str.substring(found + 2, str.length());
            right = right.trim();
            right = SqlRender.removeParentheses(right);
            return left.equals(right);
        }
        found = str.indexOf("!=");
        if (found == -1) {
            found = str.indexOf("<>");
        }
        if (found != -1) {
            String left = str.substring(0, found);
            left = left.trim();
            left = SqlRender.removeParentheses(left);
            String right = str.substring(found + 2, str.length());
            right = right.trim();
            return !left.equals(right = SqlRender.removeParentheses(right));
        }
        found = str_lc.indexOf(" in ");
        if (found != -1) {
            String left = str.substring(0, found);
            left = left.trim();
            left = SqlRender.removeParentheses(left);
            String right = str.substring(found + 4, str.length());
            if ((right = right.trim()).length() > 2 && right.charAt(0) == '(' && right.charAt(right.length() - 1) == ')') {
                String[] parts;
                right = right.substring(1, right.length() - 1);
                for (String part : parts = right.split(",")) {
                    String partString = SqlRender.removeParentheses(part);
                    if (!left.equals(partString)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new RuntimeException("Error parsing boolean condition: \"" + str + "\"");
    }

    private static String replace(String str, List<Span> spans, int toReplaceStart, int toReplaceEnd, int replaceWithStart, int replaceWithEnd) {
        String replaceWithString = str.substring(replaceWithStart, replaceWithEnd + 1);
        str = StringUtils.replace(str, toReplaceStart, toReplaceEnd, replaceWithString);
        for (Span span : spans) {
            int delta;
            if (!span.valid) continue;
            if (span.start > toReplaceStart) {
                if (span.start >= replaceWithStart && span.start < replaceWithEnd) {
                    delta = toReplaceStart - replaceWithStart;
                    span.start += delta;
                    span.end += delta;
                    continue;
                }
                if (span.start > toReplaceEnd) {
                    delta = toReplaceStart - toReplaceEnd + replaceWithString.length();
                    span.start += delta;
                    span.end += delta;
                    continue;
                }
                span.valid = false;
                continue;
            }
            if (span.end <= toReplaceEnd) continue;
            delta = toReplaceStart - toReplaceEnd + replaceWithString.length();
            span.end += delta;
        }
        return str;
    }

    private static Map<String, String> extractDefaults(String str) {
        HashMap<String, String> defaults = new HashMap<String, String>();
        int defaultStart = 0;
        int defaultEnd = 0;
        String pre = "{DEFAULT ";
        String post = "}";
        while (defaultStart != -1 && defaultEnd != -1) {
            String span;
            int found;
            defaultStart = str.indexOf(pre, defaultEnd);
            if (defaultStart == -1 || (defaultEnd = str.indexOf(post, defaultStart + pre.length())) == -1 || (found = (span = str.substring(defaultStart + pre.length(), defaultEnd)).indexOf("=")) == -1) continue;
            String parameter = span.substring(0, found);
            if ((parameter = parameter.trim()).length() > 0 && parameter.charAt(0) == '@') {
                parameter = parameter.substring(1);
            }
            String defaultValue = span.substring(found + 2, span.length());
            defaultValue = defaultValue.trim();
            defaultValue = SqlRender.removeParentheses(defaultValue);
            defaults.put(parameter, defaultValue);
        }
        return defaults;
    }

    private static String substituteParameters(String string, Map<String, String> parameterToValue) {
        Map<String, String> defaults = SqlRender.extractDefaults(string);
        string = SqlRender.removeDefaults(string);
        for (Map.Entry<String, String> pair : defaults.entrySet()) {
            if (parameterToValue.containsKey(pair.getKey())) continue;
            parameterToValue.put(pair.getKey(), pair.getValue());
        }
        ArrayList<Map.Entry<String, String>> sortedParameterToValue = new ArrayList<Map.Entry<String, String>>(parameterToValue.entrySet());
        Collections.sort(sortedParameterToValue, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                int l2;
                int l1 = o1.getKey().length();
                if (l1 > (l2 = o2.getKey().length())) {
                    return -1;
                }
                if (l1 < l2) {
                    return 1;
                }
                return 0;
            }
        });
        for (Map.Entry entry : sortedParameterToValue) {
            String key = (String)entry.getKey();
            String value = ((String)entry.getValue()).replaceAll("\\\\", "\\\\\\\\");
            string = string.replaceAll("@" + key, SqlRender.escapeDollarSign(value));
        }
        return string;
    }

    public static String escapeDollarSign(String s) {
        if (s.indexOf(36) == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '$') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String removeDefaults(String string) {
        return string.replaceAll("\\{DEFAULT[^}]*\\}\\s*\n?", "");
    }

    private static String parseIfThenElse(String str) {
        List<Span> spans = SqlRender.findCurlyBracketSpans(str);
        List<IfThenElse> ifThenElses = SqlRender.linkIfThenElses(str, spans);
        String result = new String(str);
        for (IfThenElse ifThenElse : ifThenElses) {
            if (!ifThenElse.condition.valid) continue;
            if (SqlRender.evaluateCondition(result.substring(ifThenElse.condition.start + 1, ifThenElse.condition.end - 1))) {
                result = SqlRender.replace(result, spans, ifThenElse.start(), ifThenElse.end(), ifThenElse.ifTrue.start + 1, ifThenElse.ifTrue.end - 2);
                continue;
            }
            if (ifThenElse.hasIfFalse) {
                result = SqlRender.replace(result, spans, ifThenElse.start(), ifThenElse.end(), ifThenElse.ifFalse.start + 1, ifThenElse.ifFalse.end - 2);
                continue;
            }
            result = SqlRender.replace(result, spans, ifThenElse.start(), ifThenElse.end(), 0, -1);
        }
        return result;
    }

    private static String renderSql(String str, Map<String, String> parameterToValue) {
        String result = SqlRender.substituteParameters(str, parameterToValue);
        result = SqlRender.parseIfThenElse(result);
        return result;
    }

    public static String renderSql(String sql, String[] parameters, String[] values) {
        HashMap<String, String> parameterToValue = new HashMap<String, String>();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                parameterToValue.put(parameters[i], values[i]);
            }
        }
        return SqlRender.renderSql(sql, parameterToValue);
    }

    public static String[] check(String sql, String[] parameters, String[] values) {
        ArrayList<String> warnings = new ArrayList<String>();
        if (parameters != null) {
            for (String parameter : parameters) {
                if (sql.contains("@" + parameter)) continue;
                warnings.add("Parameter '" + parameter + "' not found in SQL");
            }
        }
        return warnings.toArray(new String[warnings.size()]);
    }

    private static class IfThenElse {
        public Span condition;
        public Span ifTrue;
        public Span ifFalse;
        public boolean hasIfFalse = false;

        private IfThenElse() {
        }

        public int start() {
            return this.condition.start;
        }

        int end() {
            return this.hasIfFalse ? this.ifFalse.end : this.ifTrue.end;
        }
    }

    private static class Span {
        public int start;
        public int end;
        public boolean valid;

        public Span(int start, int end) {
            this.start = start;
            this.end = end;
            this.valid = true;
        }
    }
}

