/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo.seriestest;

import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.modelling.arima.tramo.spectrum.PeaksEnum;
import ec.tstoolkit.modelling.arima.tramo.spectrum.Spect;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.Arrays;

public class OverSeasTest {
    private TsData serie;
    private int checkQs;
    private int checkSNP;
    private int checkPeaks;
    private PeaksEnum[] peaks;
    private boolean diff;
    private int checkOverSeasTest;

    public int getCheckOverSeasTest() {
        return this.checkOverSeasTest;
    }

    public int getCheckPeaks() {
        return this.checkPeaks;
    }

    public int getCheckQs() {
        return this.checkQs;
    }

    public int getCheckSNP() {
        return this.checkSNP;
    }

    public OverSeasTest(TsData targetS, PeaksEnum[] Peaks2, boolean Diff) {
        this.serie = targetS;
        this.checkQs = 0;
        this.checkSNP = 0;
        this.checkPeaks = 0;
        this.peaks = Peaks2;
        this.diff = Diff;
        this.checkOverSeasTest = this.ComputeOverSeasTest();
    }

    public static double Kendalls(TsData targetS) {
        int i;
        int i2;
        double retVal = 0.0;
        if (targetS.getFrequency().intValue() <= 1) {
            return retVal;
        }
        int Nz = targetS.getLength();
        double[] data = new double[Nz];
        for (int i3 = 0; i3 < Nz; ++i3) {
            data[i3] = targetS.get(i3);
        }
        int Mq = targetS.getFrequency().intValue();
        int Ny = Nz / Mq;
        int res = Nz - Ny * Mq;
        double[][] r = new double[Ny][Mq];
        for (i2 = 0; i2 < Ny; ++i2) {
            Arrays.fill(r[i2], 0.0);
        }
        double[] obs = new double[Mq];
        for (i2 = 0; i2 < Ny; ++i2) {
            int k;
            for (int j = 0; j < Mq; ++j) {
                obs[j] = data[res + i2 * Mq + j];
            }
            int MaxLoop = 0;
            int LoopMax = 1000;
            for (int ind = 1; ind <= Mq && MaxLoop < LoopMax; ind += k) {
                ++MaxLoop;
                DescriptiveStatistics bs = new DescriptiveStatistics(obs);
                double min_val = bs.getMin();
                k = 0;
                int[] found = new int[Mq];
                for (int j = 0; j < Mq; ++j) {
                    found[j] = 0;
                    if (!(Math.abs(obs[j] - min_val) < 1.0E-20)) continue;
                    ++k;
                    found[j] = 1;
                }
                double value = (double)ind + (double)(k - 1) / 2.0;
                for (int j = 0; j < Mq; ++j) {
                    if (found[j] != 1) continue;
                    obs[j] = Double.MAX_VALUE;
                    r[i2][j] = value;
                }
            }
            if (MaxLoop <= LoopMax) continue;
            return retVal;
        }
        double[] m = new double[Mq];
        for (i = 0; i < Mq; ++i) {
            double sum = 0.0;
            for (int j = 0; j < Ny; ++j) {
                sum += r[j][i];
            }
            m[i] = sum;
        }
        for (i = 0; i < Mq; ++i) {
            retVal += (m[i] - (double)(Ny * (Mq + 1)) / 2.0) * (m[i] - (double)(Ny * (Mq + 1)) / 2.0);
        }
        return 12.0 * retVal / (double)((Mq + 1) * Mq * Ny);
    }

    public static double CalcQs(TsData targetS) {
        double retVal = 0.0;
        if (targetS.getFrequency().intValue() == 1) {
            return retVal;
        }
        DescriptiveStatistics bs = new DescriptiveStatistics(targetS);
        double c0 = bs.getSumSquare();
        c0 /= (double)targetS.getLength();
        int Mq = targetS.getFrequency().intValue();
        int Mq2 = Mq * 2;
        double[] C = new double[Mq2];
        double[] R = new double[Mq2];
        Arrays.fill(C, 0.0);
        for (int k = 0; k < Mq2; ++k) {
            for (int i = k + 1; i < targetS.getLength(); ++i) {
                int n = k;
                C[n] = C[n] + targetS.get(i) * targetS.get(i - 1 - k);
            }
            int n = k;
            C[n] = C[n] / (double)targetS.getLength();
            R[k] = C[k] / c0;
        }
        if (R[Mq - 1] > 0.0) {
            retVal += R[Mq - 1] * R[Mq - 1] / (double)(targetS.getLength() - Mq);
            if (R[Mq2 - 1] > 0.0) {
                retVal += R[Mq2 - 1] * R[Mq2 - 1] / (double)(targetS.getLength() - Mq2);
            }
            retVal *= (double)(targetS.getLength() * (targetS.getLength() + 2));
        }
        return retVal;
    }

    private int ComputeOverSeasTest() {
        int retVal = 0;
        TsData diffS = this.serie.delta(1);
        DescriptiveStatistics bs = new DescriptiveStatistics(diffS);
        TsData targetS = diffS.minus(bs.getAverage());
        double SNPVal = OverSeasTest.Kendalls(targetS);
        if (this.diff) {
            diffS = this.serie.delta(1);
            bs = new DescriptiveStatistics(diffS);
            targetS = diffS.minus(bs.getAverage());
        } else {
            targetS = this.serie.clone();
        }
        double Qs = OverSeasTest.CalcQs(targetS);
        if (Qs > 9.21) {
            ++retVal;
            this.checkQs = 1;
        }
        if (SNPVal > 24.73 && this.serie.getFrequency() == TsFrequency.Monthly || SNPVal > 11.35 && this.serie.getFrequency() == TsFrequency.Quarterly) {
            ++retVal;
            this.checkSNP = 1;
        } else {
            this.checkSNP = 0;
        }
        if (Spect.SeasSpectCrit(this.peaks, this.serie.getFrequency())) {
            ++retVal;
            this.checkPeaks = 1;
        } else {
            this.checkPeaks = 0;
        }
        return retVal;
    }
}

