/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries;

import ec.tstoolkit.timeseries.DayOfWeek;
import ec.tstoolkit.timeseries.IPeriod;
import ec.tstoolkit.timeseries.Month;
import ec.tstoolkit.timeseries.TsException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public final class Day
implements IPeriod,
Comparable<Day> {
    public static final int DAY_OF_WEEK_T0 = 3;
    private static final int[] monthDays = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] cumulatedMonthDays = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    public static final Day BEG = new Day(1000, Month.January, 0);
    public static final Day END = new Day(2999, Month.December, 30);
    private final int day_;
    private static final long G_DAY0 = new GregorianCalendar(1970, 0, 1).getTimeInMillis();
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT_THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd"));
    private static final ThreadLocal<GregorianCalendar> CALENDAR_THREAD_LOCAL = ThreadLocal.withInitial(GregorianCalendar::new);

    public static int getMonthDays(int month) {
        return monthDays[month];
    }

    public static int getCumulatedMonthDays(int month) {
        return cumulatedMonthDays[month];
    }

    private static int calc(Date date) {
        Calendar cal = CALENDAR_THREAD_LOCAL.get();
        cal.setTime(date);
        return Day.calc(cal.get(1), cal.get(2), cal.get(5) - 1);
    }

    public static int calc(int year, int month, int day) {
        year = Day.verify(year);
        boolean bLeapYear = Day.verify(year, month, day);
        int nDate = year * 365 + year / 4 - year / 100 + year / 400 + cumulatedMonthDays[month] + day;
        if (month < 2 && bLeapYear) {
            --nDate;
        }
        return nDate - 719527;
    }

    public static int calcDays(int year, int ndays) {
        int np;
        if ((year = Day.verify(year)) < 0 || year > 3000) {
            throw new TsException("Invalid year");
        }
        if (year < 30) {
            year += 2000;
        } else if (year < 100) {
            year += 1900;
        }
        boolean bLeapYear = Day.isLeap(year);
        int n = np = bLeapYear ? 366 : 365;
        if (ndays < 0 || ndays >= np) {
            throw new TsException("Invalid day");
        }
        int rslt = year * 365 + year / 4 - year / 100 + year / 400 + ndays - 719527;
        if (bLeapYear) {
            return rslt - 1;
        }
        return rslt;
    }

    public static int subtract(Day d0, Day d1) {
        return d0.day_ - d1.day_;
    }

    public static Day toDay() {
        return new Day(new Date());
    }

    static int verify(int year) {
        if (year < 30) {
            year += 2000;
        } else if (year < 100) {
            year += 1900;
        }
        return year;
    }

    static boolean verify(int year, int month, int day) {
        year = Day.verify(year);
        if (month < 0 || month > 11) {
            throw new TsException("Invalid month");
        }
        boolean bLeapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
        int nDaysInMonth = monthDays[month];
        if (bLeapYear && day == 28 && month == 1) {
            ++nDaysInMonth;
        }
        if (day < 0 || day >= nDaysInMonth) {
            throw new TsException("Invalid day");
        }
        return bLeapYear;
    }

    public static int getNumberOfDaysByMonth(int year, int month) {
        if (month == 1 && Day.isLeap(year)) {
            return 29;
        }
        return monthDays[month];
    }

    public static boolean isLeap(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public Day(Date d) {
        this.day_ = Day.calc(d);
    }

    Day(int day) {
        this.day_ = day;
    }

    public Day(int year, Month month, int day) {
        this.day_ = Day.calc(year, month.intValue(), day);
    }

    @Override
    public int compareTo(Day o) {
        return Integer.compare(this.day_, o.day_);
    }

    @Override
    public boolean contains(Date dt) {
        return this.day_ == Day.calc(dt);
    }

    public int difference(Day d1) {
        return this.day_ - d1.day_;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Day && this.equals((Day)obj);
    }

    private boolean equals(Day other) {
        return this.day_ == other.day_;
    }

    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + this.day_;
        return hash;
    }

    @Override
    public Day firstday() {
        return this;
    }

    public DayOfWeek getDayOfWeek() {
        int d = (this.day_ - 3) % 7;
        if (d < 0) {
            d += 7;
        }
        return DayOfWeek.valueOf(d);
    }

    public int getId() {
        return this.day_;
    }

    public int getMonth() {
        return this.toInternalCalendar().get(2);
    }

    public int getYear() {
        return this.toInternalCalendar().get(1);
    }

    public boolean isAfter(Day d1) {
        return this.day_ > d1.day_;
    }

    public boolean isBefore(Day d1) {
        return this.day_ < d1.day_;
    }

    public boolean isNotAfter(Day d1) {
        return this.day_ <= d1.day_;
    }

    public boolean isNotBefore(Day d1) {
        return this.day_ >= d1.day_;
    }

    public boolean isWorkingDay() {
        int d = (this.day_ - 3) % 7;
        if (d < 0) {
            d += 7;
        }
        return d < 5;
    }

    @Override
    public Day lastday() {
        return this;
    }

    public Day minus(int ndays) {
        return new Day(this.day_ - ndays);
    }

    public Day plus(int ndays) {
        return new Day(this.day_ + ndays);
    }

    public Date getTime() {
        return new Date(this.getTimeInMillis());
    }

    public long getTimeInMillis() {
        return this.toInternalCalendar().getTimeInMillis();
    }

    public GregorianCalendar toCalendar() {
        return this.initCalendar(new GregorianCalendar());
    }

    private GregorianCalendar toInternalCalendar() {
        return this.initCalendar(CALENDAR_THREAD_LOCAL.get());
    }

    private GregorianCalendar initCalendar(GregorianCalendar cal) {
        cal.setTimeInMillis(G_DAY0);
        cal.add(5, this.day_);
        return cal;
    }

    public String toString() {
        return DATE_FORMAT_THREAD_LOCAL.get().format(this.toInternalCalendar().getTime());
    }

    public static Day fromString(String s) throws ParseException {
        return new Day(DATE_FORMAT_THREAD_LOCAL.get().parse(s));
    }
}

