/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling.trees;

import choco.cp.solver.constraints.global.scheduling.trees.AbstractThetaTree;
import choco.cp.solver.constraints.global.scheduling.trees.AbstractVilimStatus;
import choco.cp.solver.constraints.global.scheduling.trees.AbstractVilimTree;
import choco.cp.solver.constraints.global.scheduling.trees.IVilimTree;
import choco.cp.solver.constraints.global.scheduling.trees.ThetaTreeLeaf;
import choco.cp.solver.constraints.global.scheduling.trees.status.ConsumptionStatus;
import choco.kernel.common.opres.graph.IBinaryNode;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.global.scheduling.ICumulativeResource;
import choco.kernel.solver.variables.scheduling.IRTask;
import choco.kernel.solver.variables.scheduling.ITask;

public final class CumTreeT<T extends ITask>
extends AbstractThetaTree {
    protected final ICumulativeResource<T> rsc;

    public CumTreeT(ICumulativeResource<T> rsc) {
        super(rsc.asTaskList());
        this.rsc = rsc;
    }

    @Override
    public void insert(ITask task) {
        this.insertTask(task, new CumStatusT(AbstractVilimTree.NodeType.NIL), new CumStatusT(AbstractVilimTree.NodeType.INTERNAL));
    }

    public long getEnergy() {
        return ((ConsumptionStatus)((CumStatusT)this.getRoot().getNodeStatus()).getStatus()).getTime();
    }

    @Override
    public boolean insertInTheta(ITask task) {
        throw new UnsupportedOperationException("unauthorized operation");
    }

    @Override
    public int getTime() {
        throw new UnsupportedOperationException("energy is given instead of a time.");
    }

    @Override
    public void setMode(IVilimTree.TreeMode mode) {
        if (!mode.value()) {
            throw new UnsupportedOperationException("unsupported tree mode:" + (Object)((Object)mode));
        }
        super.setMode(mode);
    }

    final class CumStatusT
    extends AbstractVilimStatus<ConsumptionStatus>
    implements ThetaTreeLeaf {
        public CumStatusT(AbstractVilimTree.NodeType type) {
            super(type, new ConsumptionStatus());
        }

        @Override
        public void insertInTheta(IRTask task) {
            this.setType(AbstractVilimTree.NodeType.THETA);
            long cons = task.getMinConsumption();
            ((ConsumptionStatus)this.status).setTime((long)(CumTreeT.this.rsc.getMaxCapacity() * task.getTaskVar().getEST()) + cons);
            ((ConsumptionStatus)this.status).setConsumption(cons);
        }

        @Override
        public void insertInTheta() {
            throw new UnsupportedOperationException("cant insert without argument.");
        }

        @Override
        public void removeFromTheta() {
            this.setType(AbstractVilimTree.NodeType.NIL);
            ((ConsumptionStatus)this.getStatus()).setTime(this.getResetLongValue(CumTreeT.this.getMode()));
            ((ConsumptionStatus)this.getStatus()).setConsumption(0L);
        }

        @Override
        public void reset() {
            this.removeFromTheta();
        }

        @Override
        protected void writeDotStatus(StringBuilder buffer) {
            this.writeRow(buffer, "Energ.", this.format(((ConsumptionStatus)this.status).getTime()), "C", String.valueOf(((ConsumptionStatus)this.status).getConsumption()));
        }

        @Override
        public void updateInternalNode(IBinaryNode node) {
            if (node.getLeftChild().getNodeStatus() instanceof CumStatusT) {
                ConsumptionStatus left = (ConsumptionStatus)((CumStatusT)node.getLeftChild().getNodeStatus()).getStatus();
                if (node.getRightChild().getNodeStatus() instanceof CumStatusT) {
                    ConsumptionStatus right = (ConsumptionStatus)((CumStatusT)node.getRightChild().getNodeStatus()).getStatus();
                    ((ConsumptionStatus)this.status).update(CumTreeT.this.getMode(), left, right);
                    return;
                }
            }
            throw new SolverException("cant update node");
        }
    }
}

