# polarisR <img src="man/figures/logo.png" align="right" height="139" />

`polarisR` is a shiny application for diagnosing $2\text{-}D$ non-linear dimensionality reduction (NLDR) layouts generated using methods such as t-SNE and UMAP with different hyper-parameters. It also facilitates comparison of how the data appear in high dimensions through various tour methods, including scatter, sage, and slice. The application provides an interactive platform to explore high-dimensional datasets, diagnose NLDR layouts using the quollr package, and compare different NLDR results.

## Features

- **Data Loading**: Load your own CSV datasets or use one of the example datasets provided.
- **NLDR Methods**: Choose between t-SNE and UMAP for dimensionality reduction.
- **Interactive Visualization**: Explore the 2D NLDR layout of your data with interactive plots.
- **Dynamic Tour**: Take a dynamic tour of the high-dimensional data to understand its structure.
- **Diagnostics of NLDR Layout**: Use the `quollr` package to diagnose the NLDR layout.
- **NLDR Methods Comparison**: Compare the results of different NLDR methods and hyperparameter settings.
- **Side-by-Side Visualization**: View two visualizations (NLDR layout and tour view) side-by-side with linked brushing for a direct comparison.

## Installation

You can install `polarisR` from GitHub using the following commands in R:

```R
# Install pak if you haven't already
# install.packages("pak")

pak::pak("Divendra2006/polarisR")
```

## Usage

To run the `polarisR` shiny app, use the following command in R:

```R
polarisR::run_nldr_viz()
```

You can also upload your own dataset in CSV format.

## About the name

**p**rojective **o**utput **l**ayouts **a**nd **r**educed **i**nteractive **s**urfaces in **R**

## License

This project is licensed under the MIT License - see the [LICENSE.md](https://github.com/Divendra2006/polarisR/blob/main/LICENSE.md) file for details.


