/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.advanced.arima;

import jdplus.toolkit.base.api.data.DoubleSeq;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class ArimaModel {
    private final String name;
    private final double innovationVariance;
    @NonNull
    private final DoubleSeq ar;
    @NonNull
    private final DoubleSeq delta;
    @NonNull
    private final DoubleSeq ma;

    public ArimaModel rename(String nname) {
        return new ArimaModel(nname, this.innovationVariance, this.ar, this.delta, this.ma);
    }

    public static Builder builder() {
        return new Builder().innovationVariance(1.0).ar(DoubleSeq.one()).delta(DoubleSeq.one()).ma(DoubleSeq.one());
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public double getInnovationVariance() {
        return this.innovationVariance;
    }

    @NonNull
    @Generated
    public DoubleSeq getAr() {
        return this.ar;
    }

    @NonNull
    @Generated
    public DoubleSeq getDelta() {
        return this.delta;
    }

    @NonNull
    @Generated
    public DoubleSeq getMa() {
        return this.ma;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArimaModel)) {
            return false;
        }
        ArimaModel other = (ArimaModel)o;
        if (Double.compare(this.getInnovationVariance(), other.getInnovationVariance()) != 0) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        DoubleSeq this$ar = this.getAr();
        DoubleSeq other$ar = other.getAr();
        if (this$ar == null ? other$ar != null : !this$ar.equals(other$ar)) {
            return false;
        }
        DoubleSeq this$delta = this.getDelta();
        DoubleSeq other$delta = other.getDelta();
        if (this$delta == null ? other$delta != null : !this$delta.equals(other$delta)) {
            return false;
        }
        DoubleSeq this$ma = this.getMa();
        DoubleSeq other$ma = other.getMa();
        return !(this$ma == null ? other$ma != null : !this$ma.equals(other$ma));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $innovationVariance = Double.doubleToLongBits(this.getInnovationVariance());
        result = result * 59 + (int)($innovationVariance >>> 32 ^ $innovationVariance);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        DoubleSeq $ar = this.getAr();
        result = result * 59 + ($ar == null ? 43 : $ar.hashCode());
        DoubleSeq $delta = this.getDelta();
        result = result * 59 + ($delta == null ? 43 : $delta.hashCode());
        DoubleSeq $ma = this.getMa();
        result = result * 59 + ($ma == null ? 43 : $ma.hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "ArimaModel(name=" + this.getName() + ", innovationVariance=" + this.getInnovationVariance() + ", ar=" + String.valueOf(this.getAr()) + ", delta=" + String.valueOf(this.getDelta()) + ", ma=" + String.valueOf(this.getMa()) + ")";
    }

    @Generated
    private ArimaModel(String name, double innovationVariance, @NonNull DoubleSeq ar, @NonNull DoubleSeq delta, @NonNull DoubleSeq ma) {
        if (ar == null) {
            throw new NullPointerException("ar is marked non-null but is null");
        }
        if (delta == null) {
            throw new NullPointerException("delta is marked non-null but is null");
        }
        if (ma == null) {
            throw new NullPointerException("ma is marked non-null but is null");
        }
        this.name = name;
        this.innovationVariance = innovationVariance;
        this.ar = ar;
        this.delta = delta;
        this.ma = ma;
    }

    @Generated
    public static class Builder {
        @Generated
        private String name;
        @Generated
        private double innovationVariance;
        @Generated
        private DoubleSeq ar;
        @Generated
        private DoubleSeq delta;
        @Generated
        private DoubleSeq ma;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder innovationVariance(double innovationVariance) {
            this.innovationVariance = innovationVariance;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder ar(@NonNull DoubleSeq ar) {
            if (ar == null) {
                throw new NullPointerException("ar is marked non-null but is null");
            }
            this.ar = ar;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder delta(@NonNull DoubleSeq delta) {
            if (delta == null) {
                throw new NullPointerException("delta is marked non-null but is null");
            }
            this.delta = delta;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder ma(@NonNull DoubleSeq ma) {
            if (ma == null) {
                throw new NullPointerException("ma is marked non-null but is null");
            }
            this.ma = ma;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull ArimaModel build() {
            return new ArimaModel(this.name, this.innovationVariance, this.ar, this.delta, this.ma);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "ArimaModel.Builder(name=" + this.name + ", innovationVariance=" + this.innovationVariance + ", ar=" + String.valueOf(this.ar) + ", delta=" + String.valueOf(this.delta) + ", ma=" + String.valueOf(this.ma) + ")";
        }
    }
}

