/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.lapack;

import jdplus.toolkit.base.core.math.matrices.CPointer;
import jdplus.toolkit.base.core.math.matrices.DataPointer;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixTransformation;
import jdplus.toolkit.base.core.math.matrices.RPointer;
import lombok.Generated;

public final class GEMV {
    public static void apply(double alpha, FastMatrix A, DataPointer x, double beta, DataPointer y, MatrixTransformation ta) {
        block4: {
            int xinc;
            int n;
            int m;
            block3: {
                m = A.getRowsCount();
                n = A.getColumnsCount();
                if (m == 0 || n == 0 || alpha == 0.0 && beta == 1.0) {
                    return;
                }
                xinc = x.inc();
                if (ta != MatrixTransformation.None) break block3;
                y.mul(m, beta);
                if (alpha == 0.0) break block4;
                int jxmax = x.pos() + xinc * n;
                CPointer acol = new CPointer(A.getStorage(), A.getStartPosition());
                for (int jx = x.pos(); jx < jxmax; jx += xinc) {
                    double tmp = alpha * x.p()[jx];
                    y.addAX(m, tmp, acol);
                    acol.move(A.getColumnIncrement());
                }
                break block4;
            }
            y.mul(n, beta);
            int jxmax = x.pos() + xinc * m;
            RPointer arow = new RPointer(A.getStorage(), A.getStartPosition(), A.getColumnIncrement());
            for (int jx = x.pos(); jx < jxmax; jx += xinc) {
                double tmp = alpha * x.p()[jx];
                y.addAX(n, tmp, arow);
                arow.next();
            }
        }
    }

    @Generated
    private GEMV() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

