/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.polynomials;

import java.util.Random;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.GeneralMatrix;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.RootsSolver;

public class FastEigenValuesSolver
implements RootsSolver {
    private Complex[] roots;
    private Rotator[] Q;
    private Rotator[] C;
    private Rotator[] B;
    private int n;
    private int start;
    private int stop;
    private int zero;
    private int it_max;
    private int it_count;
    private int chase_count;
    private int tr;
    private int[] its;
    private double tol = Constants.getEpsilon();
    private Complex[] shifts;
    private FastMatrix D = FastMatrix.square(2);
    private Rotator B1 = new Rotator();
    private Rotator B2 = new Rotator();
    private Rotator B3 = new Rotator();
    private Rotator tmp = new Rotator();
    private Rotator B1b = new Rotator();
    private Rotator B2b = new Rotator();

    @Override
    public boolean factorize(Polynomial p) {
        this.n = p.degree();
        this.roots = new Complex[this.n];
        switch (this.n) {
            case 0: {
                return true;
            }
            case 1: {
                this.monic(p);
                return true;
            }
            case 2: {
                this.quadratic(p);
                return true;
            }
        }
        this.qr(p);
        return true;
    }

    @Override
    public Polynomial remainder() {
        return Polynomial.ZERO;
    }

    @Override
    public Complex[] roots() {
        return this.roots;
    }

    private void monic(Polynomial p) {
        double a = p.get(1);
        double b = p.get(0);
        this.roots[0] = Complex.cart((double)(-b / a));
    }

    private void quadratic(Polynomial p) {
        double a = p.get(2);
        double b = p.get(1);
        double c = p.get(0);
        double aa = 2.0 * a;
        double rdiscr = b * b - 4.0 * a * c;
        if (rdiscr < 0.0) {
            Complex r;
            double z = Math.sqrt(-rdiscr);
            this.roots[0] = r = Complex.cart((double)(-b / aa), (double)(z / aa));
            this.roots[1] = r.conj();
        } else {
            double z = Math.sqrt(rdiscr);
            this.roots[0] = Complex.cart((double)((-b + z) / aa));
            this.roots[1] = Complex.cart((double)((-b - z) / aa));
        }
    }

    private void qr(Polynomial p) {
        this.its = new int[this.n];
        this.initialize(p);
        this.tr = this.n - 3;
        this.start = 0;
        this.stop = this.n - 2;
        this.zero = -1;
        this.it_max = 30 * this.n;
        this.it_count = 0;
        this.chase_count = 0;
        this.shifts = new Complex[2];
        for (int k = 0; k < this.it_max; ++k) {
            if (this.stop < 0) {
                return;
            }
            this.checkDeflation();
            if (this.updateRoots()) continue;
            ++this.it_count;
            this.bulge();
        }
    }

    private void bulge() {
        if (this.it_count % 25 != 0) {
            this.diagonalBlock(this.stop, this.D);
            this.eigenValues(this.D, this.shifts, 0);
        } else {
            this.diagonalBlock(this.stop, this.D);
            Random rnd = new Random();
            double r = rnd.nextGaussian();
            double i = rnd.nextGaussian();
            this.shifts[0] = Complex.cart((double)r, (double)i);
            this.shifts[1] = Complex.cart((double)r, (double)(-i));
        }
        this.diagonalBlock(this.start, this.D);
        double t00 = this.D.get(0, 0);
        double t10 = this.D.get(1, 0);
        double t01 = this.D.get(0, 1);
        double t11 = this.D.get(1, 1);
        this.diagonalBlock(this.start + 1, this.D);
        double t21 = this.D.get(1, 0);
        double c0 = t00 * t00 + t01 * t10 + this.shifts[0].getRe() * this.shifts[1].getRe() - this.shifts[0].getIm() * this.shifts[1].getIm() - t00 * (this.shifts[0].getRe() + this.shifts[1].getRe());
        double c1 = t10 * (t00 + t11 - this.shifts[0].getRe() - this.shifts[1].getRe());
        double c2 = t10 * t21;
        double r = FastEigenValuesSolver.givensRotation(c1, c2, this.B1);
        FastEigenValuesSolver.givensRotation2(c0, r, this.B2);
        this.chase();
    }

    private void chase() {
        ++this.chase_count;
        if (this.start == 0) {
            this.tmp.copyInverse(this.B2);
            this.B3.copyInverse(this.B1);
            Rotator.turnover(this.tmp, this.B3, this.Q[0]);
            Rotator.fuse(this.B3, this.Q[1], 1);
            this.B3.copy(this.Q[0]);
            this.Q[0].copy(this.tmp);
        } else {
            this.tmp.c = this.B2.c;
            this.tmp.s = -this.Q[this.start - 1].c * this.B2.s;
            this.B3.copyInverse(this.B1);
            Rotator.turnover(this.tmp, this.B3, this.Q[this.start]);
            Rotator.fuse(this.B3, this.Q[this.start + 1], 1);
            this.B3.copy(this.Q[this.start]);
            this.Q[this.start].copy(this.tmp);
        }
        for (int i = this.start; i <= this.stop - 2; ++i) {
            if (i < this.tr - 1) {
                this.B1b.copy(this.B1);
                this.B2b.copy(this.B2);
                Rotator.turnover(this.B[i + 1], this.B[i + 2], this.B1b);
                Rotator.turnover(this.B[i], this.B[i + 1], this.B2b);
                this.C[i].copyInverse(this.B[i]);
                this.C[i + 1].copyInverse(this.B[i + 1]);
                this.C[i + 2].copyInverse(this.B[i + 2]);
            } else {
                Rotator.turnover(this.B[i + 1], this.B[i + 2], this.B1);
                Rotator.turnover(this.B[i], this.B[i + 1], this.B2);
                Rotator.turnover(this.C[i + 2], this.C[i + 1], this.B1);
                Rotator.turnover(this.C[i + 1], this.C[i], this.B2);
            }
            Rotator.turnover(this.Q[i + 1], this.Q[i + 2], this.B1);
            Rotator.turnover(this.Q[i], this.Q[i + 1], this.B2);
            Rotator.turnover(this.B3, this.B1, this.B2);
            this.tmp.copy(this.B2);
            this.B2.copy(this.B3);
            this.B3.copy(this.B1);
            this.B1.copy(this.tmp);
        }
        Rotator.turnover(this.B[this.stop], this.B[this.stop + 1], this.B1);
        Rotator.turnover(this.B[this.stop - 1], this.B[this.stop], this.B2);
        Rotator.turnover(this.C[this.stop + 1], this.C[this.stop], this.B1);
        Rotator.turnover(this.C[this.stop], this.C[this.stop - 1], this.B2);
        this.B1.s *= this.Q[this.stop + 1].c;
        Rotator.fuse(this.Q[this.stop], this.B1, 0);
        Rotator.turnover(this.Q[this.stop - 1], this.Q[this.stop], this.B2);
        Rotator.fuse(this.B3, this.B2, 0);
        Rotator.turnover(this.B[this.stop], this.B[this.stop + 1], this.B3);
        Rotator.turnover(this.C[this.stop + 1], this.C[this.stop], this.B3);
        this.B3.s *= this.Q[this.stop + 1].c;
        Rotator.fuse(this.Q[this.stop], this.B3, 0);
        this.tr -= 2;
    }

    private void diagonalBlock(int k, FastMatrix D) {
        D.set(0.0);
        if (k == 0) {
            FastMatrix R = FastMatrix.square(2);
            R.set(0, 0, -this.B[0].s / this.C[0].s);
            double r11 = -this.B[1].s / this.C[1].s;
            R.set(0, 1, -(this.B[0].c * this.B[1].c - r11 * this.C[0].c * this.C[1].c) / this.C[0].s);
            R.set(1, 1, r11 * this.Q[1].c);
            FastMatrix A = FastMatrix.square(2);
            A.set(0, 0, this.Q[0].c);
            A.set(1, 0, this.Q[0].s);
            A.set(0, 1, -this.Q[0].s);
            A.set(1, 1, this.Q[0].c);
            GeneralMatrix.aAB_p_bC(1.0, A, R, 0.0, D);
        } else {
            FastMatrix R = FastMatrix.make(3, 2);
            double r10 = -this.B[k].s / this.C[k].s;
            R.set(1, 0, r10);
            R.set(0, 0, -(this.B[k - 1].c * this.B[k].c - r10 * this.C[k - 1].c * this.C[k].c) / this.C[k - 1].s);
            double r21 = -this.B[k + 1].s / this.C[k + 1].s;
            R.set(0, 1, (this.B[k - 1].c * this.B[k].s * this.B[k + 1].c - this.C[k - 1].c * (this.C[k].c * this.B[k].c * this.B[k + 1].c - this.C[k + 1].c * r21) / this.C[k].s) / this.C[k - 1].s);
            R.set(1, 1, -(this.B[k].c * this.B[k + 1].c - r21 * this.C[k].c * this.C[k + 1].c) / this.C[k].s);
            R.set(2, 1, r21 * this.Q[k + 1].c);
            FastMatrix A = FastMatrix.square(2);
            A.set(0, 0, this.Q[k].c);
            A.set(1, 0, this.Q[k].s);
            A.set(0, 1, -this.Q[k].s);
            A.set(1, 1, this.Q[k].c);
            FastMatrix R12 = R.extract(1, 2, 0, 2);
            R12.copy(GeneralMatrix.AB(A, R12));
            A.set(0, 0, this.Q[k - 1].c);
            A.set(1, 0, this.Q[k - 1].s);
            A.set(0, 1, -this.Q[k - 1].s);
            A.set(1, 1, this.Q[k - 1].c);
            FastMatrix R01 = R.extract(0, 2, 0, 2);
            R01.copy(GeneralMatrix.AB(A, R01));
            D.copy(R12);
        }
    }

    private void initialize(Polynomial p) {
        this.Q = new Rotator[this.n];
        this.C = new Rotator[this.n];
        this.B = new Rotator[this.n];
        int n1 = this.n - 1;
        for (int i = 0; i < n1; ++i) {
            this.Q[i] = new Rotator(0.0, 1.0);
        }
        this.Q[n1] = new Rotator(1.0, 0.0);
        double u = this.n % 2 == 0 ? -1.0 : 1.0;
        double v = -u;
        Rotator c = new Rotator();
        double pn = p.get(this.n);
        double r = FastEigenValuesSolver.givensRotation(v * p.get(0) / pn, u, c);
        this.C[n1] = c;
        this.B[n1] = new Rotator(v * c.s, v * c.c);
        for (int i = this.n - 1; i > 0; --i) {
            c = new Rotator();
            r = FastEigenValuesSolver.givensRotation(-p.get(i) / pn, r, c);
            this.C[i - 1] = c;
            this.B[i - 1] = new Rotator(c.c, -c.s);
        }
    }

    private static double givensRotation(double a, double b, Rotator gr) {
        double c;
        double r;
        double s;
        double absb;
        if (b == 0.0) {
            if (a < 0.0) {
                gr.c = -1.0;
                gr.s = 0.0;
                return -a;
            }
            gr.c = 1.0;
            gr.s = 0.0;
            return a;
        }
        double absa = Math.abs(a);
        if (absa >= (absb = Math.abs(b))) {
            s = b / a;
            r = Math.sqrt(1.0 + s * s);
            if (a < 0.0) {
                c = -1.0 / r;
                s *= c;
                r *= -a;
            } else {
                c = 1.0 / r;
                s *= c;
                r *= a;
            }
        } else {
            c = a / b;
            r = Math.sqrt(1.0 + c * c);
            if (b < 0.0) {
                s = -1.0 / r;
                c *= s;
                r *= -b;
            } else {
                s = 1.0 / r;
                c *= s;
                r *= b;
            }
        }
        gr.c = c;
        gr.s = s;
        return r;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void givensRotation2(double a, double b, Rotator gr) {
        double c;
        double s;
        double absb;
        if (b == 0.0) {
            if (a < 0.0) {
                gr.c = -1.0;
                gr.s = 0.0;
                return;
            }
            gr.c = 1.0;
            gr.s = 0.0;
            return;
        }
        double absa = Math.abs(a);
        if (absa >= (absb = Math.abs(b))) {
            s = b / a;
            double r = Math.sqrt(1.0 + s * s);
            if (a < 0.0) {
                c = -1.0 / r;
                s *= c;
            } else {
                c = 1.0 / r;
                s *= c;
            }
        } else {
            c = a / b;
            double r = Math.sqrt(1.0 + c * c);
            if (b < 0.0) {
                s = -1.0 / r;
                c *= s;
            } else {
                s = 1.0 / r;
                c *= s;
            }
        }
        gr.c = c;
        gr.s = s;
    }

    private void checkDeflation() {
        for (int i = this.stop; i >= 0; --i) {
            if (!this.Q[i].simplify(this.tol)) continue;
            this.zero = i;
            this.start = i + 1;
            this.its[this.zero] = this.it_count;
            this.it_count = 0;
            return;
        }
    }

    private boolean updateRoots() {
        if (this.stop == this.zero) {
            this.diagonalBlock(this.stop, this.D);
            if (this.stop == 0) {
                this.roots[this.stop] = Complex.cart((double)this.D.get(0, 0));
                this.roots[this.stop + 1] = Complex.cart((double)this.D.get(1, 1));
                this.stop = -1;
            } else {
                this.roots[this.stop + 1] = Complex.cart((double)this.D.get(1, 1));
                --this.stop;
                this.zero = -1;
                this.start = 0;
            }
            return true;
        }
        if (this.stop - 1 == this.zero) {
            this.diagonalBlock(this.stop, this.D);
            this.eigenValues(this.D, this.roots, this.stop);
            if (this.stop == 1) {
                this.diagonalBlock(0, this.D);
                this.roots[0] = Complex.cart((double)this.D.get(0, 0));
            }
            this.stop -= 2;
            this.zero = -1;
            this.start = 0;
            return true;
        }
        return false;
    }

    private void eigenValues(FastMatrix M, Complex[] ev, int pos) {
        double detm;
        double m00 = M.get(0, 0);
        double m01 = M.get(0, 1);
        double m10 = M.get(1, 0);
        double m11 = M.get(1, 1);
        double trace = m00 + m11;
        double disc = trace * trace - 4.0 * (detm = m00 * m11 - m10 * m01);
        if (disc < 0.0) {
            Complex v;
            ev[pos] = v = Complex.cart((double)(trace / 2.0), (double)(Math.sqrt(-disc) / 2.0));
            ev[pos + 1] = v.conj();
        } else {
            double qm;
            double sdisc = Math.sqrt(disc);
            double qp = Math.abs(trace + sdisc);
            if (qp > (qm = Math.abs(trace - sdisc))) {
                double re = (trace + sdisc) / 2.0;
                ev[pos] = Complex.cart((double)re);
                ev[pos + 1] = Complex.cart((double)(detm / re));
            } else if (qm > 0.0) {
                double re = (trace - sdisc) / 2.0;
                ev[pos] = Complex.cart((double)re);
                ev[pos + 1] = Complex.cart((double)(detm / re));
            } else {
                ev[pos] = Complex.ZERO;
                ev[pos + 1] = Complex.ZERO;
            }
        }
    }

    static final class Rotator
    implements Cloneable {
        double c;
        double s;

        Rotator(double c, double s) {
            this.c = c;
            this.s = s;
        }

        Rotator() {
            this.c = 1.0;
            this.s = 0.0;
        }

        FastMatrix asMatrix(int n, int pos) {
            FastMatrix M = FastMatrix.identity(n);
            this.fill(M.extract(pos, 2, pos, 2));
            return M;
        }

        void fill(FastMatrix m) {
            m.set(0, 0, this.c);
            m.set(0, 1, -this.s);
            m.set(1, 0, this.s);
            m.set(1, 1, this.c);
        }

        boolean simplify(double eps) {
            if (Math.abs(this.s) <= eps) {
                this.s = 0.0;
                this.c = this.c > 0.0 ? 1.0 : -1.0;
                return true;
            }
            return false;
        }

        public Rotator clone() {
            try {
                return (Rotator)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                return null;
            }
        }

        public static void fuse(Rotator q1, Rotator q2) {
            double tmp = q1.c * q2.c - q1.s * q2.s;
            q1.s = q1.s * q2.c + q1.c * q2.s;
            q1.c = tmp;
        }

        public static void fuse(Rotator q1, Rotator q2, int type) {
            if (type == 0) {
                double tmp = q1.c * q2.c - q1.s * q2.s;
                q1.s = q1.s * q2.c + q1.c * q2.s;
                q1.c = tmp;
            } else {
                double tmp = q1.c * q2.c - q1.s * q2.s;
                q2.s = q1.s * q2.c + q1.c * q2.s;
                q2.c = tmp;
            }
        }

        public void clear() {
            this.c = 1.0;
            this.s = 0.0;
        }

        public static void turnover(Rotator q1, Rotator q2, Rotator q3) {
            double c1 = q1.c;
            double s1 = q1.s;
            double c2 = q2.c;
            double s2 = q2.s;
            double c3 = q3.c;
            double s3 = q3.s;
            double a = s1 * c3 + c1 * c2 * s3;
            double b = s2 * s3;
            Rotator q = new Rotator();
            double nrm = FastEigenValuesSolver.givensRotation(a, b, q);
            double c4 = q.c;
            double s4 = q.s;
            a = c1 * c3 - s1 * c2 * s3;
            b = nrm;
            FastEigenValuesSolver.givensRotation2(a, b, q);
            double c5 = q.c;
            double s5 = q.s;
            double t1 = s1 * s2;
            double t2 = -c1 * s2;
            double t3 = c2;
            a = -t2 * s4 + t3 * c4;
            t2 = t2 * c4 + t3 * s4;
            b = -(-t1 * s5 + t2 * c5);
            FastEigenValuesSolver.givensRotation2(a, b, q);
            double c6 = q.c;
            double s6 = q.s;
            q1.c = c5;
            q1.s = s5;
            q2.c = c6;
            q2.s = s6;
            q3.c = c4;
            q3.s = s4;
        }

        public void copy(Rotator rotator) {
            this.c = rotator.c;
            this.s = rotator.s;
        }

        private void copyInverse(Rotator rotator) {
            this.c = rotator.c;
            this.s = -rotator.s;
        }
    }
}

