/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.data.ParametersEstimation;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsResiduals;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.api.timeseries.regression.MissingValueEstimation;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.TrendConstant;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.Regression;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodStatistics;
import jdplus.toolkit.base.core.timeseries.simplets.Transformations;

public interface GeneralLinearModel<M>
extends Explorable {
    public Description<M> getDescription();

    public Estimation getEstimation();

    public TsResiduals getResiduals();

    default public TsData deterministicEffect(TsDomain domain, Predicate<Variable> test) {
        Description<M> description = this.getDescription();
        Estimation estimation = this.getEstimation();
        if (domain == null) {
            domain = description.getSeries().getDomain();
        }
        DataBlock all = DataBlock.make(domain.getLength());
        Variable[] variables = description.getVariables();
        if (variables.length > 0) {
            DoubleSeqCursor cursor = estimation.getCoefficients().cursor();
            for (int i = 0; i < variables.length; ++i) {
                Variable cur = variables[i];
                if (test.test(cur)) {
                    FastMatrix m = Regression.matrix(domain, cur.getCore());
                    int ic = 0;
                    DataBlockIterator cols = m.columnsIterator();
                    while (cols.hasNext()) {
                        Parameter c;
                        DataBlock col = cols.next();
                        if ((c = cur.getCoefficient(ic++)).isFree()) {
                            all.addAY(cursor.getAndNext(), col);
                            continue;
                        }
                        all.addAY(c.getValue(), col);
                    }
                    continue;
                }
                cursor.skip(cur.freeCoefficientsCount());
            }
        }
        return TsData.ofInternal((TsPeriod)domain.getStartPeriod(), (double[])all.getStorage());
    }

    default public TsData deterministicEffect(TsDomain domain) {
        return this.deterministicEffect(domain, v -> true);
    }

    default public boolean isMeanCorrection() {
        Description<M> description = this.getDescription();
        Variable[] variables = description.getVariables();
        for (int i = 0; i < variables.length; ++i) {
            if (!(variables[i].getCore() instanceof TrendConstant)) continue;
            return true;
        }
        return false;
    }

    default public boolean isMeanEstimation() {
        Description<M> description = this.getDescription();
        Variable[] variables = description.getVariables();
        for (int i = 0; i < variables.length; ++i) {
            if (!(variables[i].getCore() instanceof TrendConstant)) continue;
            return variables[i].isFree();
        }
        return false;
    }

    default public TsData linearizedSeries() {
        Description<M> description = this.getDescription();
        TsData interp = this.interpolatedSeries(true);
        Variable[] variables = description.getVariables();
        if (variables.length == 0) {
            return interp;
        }
        TsData det = this.deterministicEffect(interp.getDomain(), v -> true);
        return TsData.subtract((TsData)interp, (TsData)det);
    }

    default public TsData backTransform(TsData s, boolean includeLp) {
        if (s.isEmpty()) {
            return s;
        }
        Description<M> description = this.getDescription();
        if (description.isLogTransformation()) {
            s = s.exp();
            if (includeLp && description.getLengthOfPeriodTransformation() != LengthOfPeriodType.None) {
                s = Transformations.lengthOfPeriod(description.getLengthOfPeriodTransformation()).converse().transform(s, null);
            }
        }
        return s;
    }

    default public TsData transform(TsData s, boolean includeLp) {
        Description<M> description = this.getDescription();
        if (description.isLogTransformation()) {
            if (includeLp && description.getLengthOfPeriodTransformation() != LengthOfPeriodType.None) {
                s = Transformations.lengthOfPeriod(description.getLengthOfPeriodTransformation()).transform(s, null);
            }
            s = s.log();
        }
        return s;
    }

    default public TsData transformedSeries() {
        Description<M> description = this.getDescription();
        LengthOfPeriodType lp = description.getLengthOfPeriodTransformation();
        TsData tmp = description.getSeries();
        if (description.isLogTransformation()) {
            if (lp != LengthOfPeriodType.None) {
                tmp = Transformations.lengthOfPeriod(lp).transform(tmp, null);
            }
            tmp = Transformations.log().transform(tmp, null);
        }
        return tmp;
    }

    default public TsData interpolatedSeries(boolean bTransformed) {
        TsData data;
        Description<M> description = this.getDescription();
        Estimation estimation = this.getEstimation();
        MissingValueEstimation[] missing = estimation.getMissing();
        int nmissing = missing.length;
        TsData tsData = data = bTransformed ? this.transformedSeries() : description.getSeries();
        if (nmissing > 0) {
            TsDomain domain = description.getDomain();
            int dpos = domain.getStartPeriod().until(estimation.getDomain().getStartPeriod());
            double[] datac = data.getValues().toArray();
            for (int i = 0; i < nmissing; ++i) {
                int pos = dpos + missing[i].getPosition();
                TsDomain mdom = TsDomain.of((TsPeriod)domain.get(pos), (int)1);
                TsData de = this.preadjustmentEffect(mdom, v -> true);
                if (bTransformed || !description.isLogTransformation()) {
                    datac[pos] = missing[i].getValue() + de.getValue(0);
                    continue;
                }
                de = this.backTransform(de, true);
                datac[pos] = Math.exp(missing[i].getValue()) * de.getValue(0);
            }
            data = TsData.ofInternal((TsPeriod)description.getSeries().getStart(), (double[])datac);
        }
        return data;
    }

    default public double[] missingEstimates() {
        Description<M> description = this.getDescription();
        Estimation estimation = this.getEstimation();
        MissingValueEstimation[] missing = estimation.getMissing();
        int nmissing = missing.length;
        double[] missingvals = new double[nmissing];
        if (nmissing > 0) {
            TsDomain domain = description.getDomain();
            int dpos = domain.getStartPeriod().until(estimation.getDomain().getStartPeriod());
            for (int i = 0; i < nmissing; ++i) {
                int pos = dpos + missing[i].getPosition();
                TsDomain mdom = TsDomain.of((TsPeriod)domain.get(pos), (int)1);
                TsData preadjust = this.preadjustmentEffect(mdom, v -> true);
                missingvals[i] = missing[i].getValue() + preadjust.getValue(0);
                if (!description.isLogTransformation()) {
                    missingvals[i] = missing[i].getValue() + preadjust.getValue(0);
                    continue;
                }
                preadjust = this.backTransform(preadjust, true);
                missingvals[i] = Math.exp(missing[i].getValue()) * preadjust.getValue(0);
            }
        }
        return missingvals;
    }

    default public int regressionVariablesDim() {
        Variable[] variables = this.getDescription().getVariables();
        return Arrays.stream(variables).mapToInt(v -> v.freeCoefficientsCount()).sum();
    }

    default public FastMatrix regressionMatrix(TsDomain domain) {
        int nvars = this.regressionVariablesDim();
        if (nvars == 0) {
            return null;
        }
        FastMatrix M = FastMatrix.make(domain.getLength(), nvars);
        Variable[] variables = this.getDescription().getVariables();
        int cur = 0;
        for (Variable v : variables) {
            FastMatrix x;
            if (v.isPreadjustment() || (x = Regression.matrix(domain, v.getCore())) == null) continue;
            DataBlockIterator columns = x.columnsIterator();
            int ic = 0;
            while (columns.hasNext()) {
                DataBlock col = columns.next();
                if (!v.getCoefficient(ic++).isFree()) continue;
                M.column(cur++).copy(col);
            }
        }
        return M;
    }

    default public TsData regressionEffect(TsDomain domain, Predicate<Variable> test) {
        Description<M> description = this.getDescription();
        Estimation estimation = this.getEstimation();
        if (domain == null) {
            domain = description.getSeries().getDomain();
        }
        Variable[] variables = description.getVariables();
        DataBlock all = DataBlock.make(domain.getLength());
        if (variables.length > 0) {
            DoubleSeqCursor cursor = estimation.getCoefficients().cursor();
            for (int i = 0; i < variables.length; ++i) {
                Variable cur = variables[i];
                int nfree = cur.freeCoefficientsCount();
                if (nfree <= 0) continue;
                if (test.test(cur)) {
                    FastMatrix m = Regression.matrix(domain, cur.getCore());
                    int ic = 0;
                    DataBlockIterator cols = m.columnsIterator();
                    while (cols.hasNext()) {
                        Parameter c;
                        DataBlock col = cols.next();
                        if (!(c = cur.getCoefficient(ic++)).isFree()) continue;
                        all.addAY(cursor.getAndNext(), col);
                    }
                    continue;
                }
                cursor.skip(nfree);
            }
        }
        return TsData.ofInternal((TsPeriod)domain.getStartPeriod(), (double[])all.getStorage());
    }

    default public TsData preadjustmentEffect(TsDomain domain, Predicate<Variable> test) {
        Description<M> description = this.getDescription();
        Variable[] variables = description.getVariables();
        DataBlock all = DataBlock.make(domain.getLength());
        if (variables.length > 0) {
            for (int i = 0; i < variables.length; ++i) {
                Variable cur = variables[i];
                int nfree = cur.freeCoefficientsCount();
                if (cur.dim() <= nfree || !test.test(cur)) continue;
                FastMatrix m = Regression.matrix(domain, cur.getCore());
                int ic = 0;
                DataBlockIterator cols = m.columnsIterator();
                while (cols.hasNext()) {
                    Parameter c;
                    DataBlock col = cols.next();
                    if ((c = cur.getCoefficient(ic++)).isFree()) continue;
                    all.addAY(c.getValue(), col);
                }
            }
        }
        return TsData.ofInternal((TsPeriod)domain.getStartPeriod(), (double[])all.getStorage());
    }

    default public TsData getTradingDaysEffect(TsDomain domain) {
        TsData s = this.deterministicEffect(domain, v -> ModellingUtility.isDaysRelated((Variable)v));
        return this.backTransform(s, true);
    }

    default public TsData getEasterEffect(TsDomain domain) {
        TsData s = this.deterministicEffect(domain, v -> ModellingUtility.isEaster((Variable)v));
        return this.backTransform(s, false);
    }

    default public TsData getMovingHolidayEffect(TsDomain domain) {
        TsData s = this.deterministicEffect(domain, v -> ModellingUtility.isMovingHoliday((Variable)v));
        return this.backTransform(s, false);
    }

    default public TsData getOtherMovingHolidayEffect(TsDomain domain) {
        TsData s = this.deterministicEffect(domain, v -> ModellingUtility.isMovingHoliday((Variable)v) && !ModellingUtility.isEaster((Variable)v));
        return this.backTransform(s, false);
    }

    default public TsData getRamadanEffect(TsDomain domain) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    default public TsData getOutliersEffect(TsDomain domain) {
        TsData s = this.deterministicEffect(domain, v -> ModellingUtility.isOutlier((Variable)v));
        return this.backTransform(s, false);
    }

    default public TsData getOutliersEffect(TsDomain domain, boolean ami) {
        TsData s = this.deterministicEffect(domain, v -> ModellingUtility.isOutlier((Variable)v, (boolean)ami));
        return this.backTransform(s, false);
    }

    default public TsData getCalendarEffect(TsDomain domain) {
        TsData s = this.deterministicEffect(domain, v -> ModellingUtility.isCalendar((Variable)v));
        return this.backTransform(s, true);
    }

    default public TsDomain forecastDomain(int nfcast) {
        TsDomain domain = this.getDescription().getDomain();
        if (nfcast < 0) {
            nfcast = -nfcast * domain.getAnnualFrequency();
        }
        return TsDomain.of((TsPeriod)domain.getEndPeriod(), (int)nfcast);
    }

    default public TsDomain backcastDomain(int nbcast) {
        TsDomain domain = this.getDescription().getDomain();
        if (nbcast < 0) {
            nbcast = -nbcast * domain.getAnnualFrequency();
        }
        TsPeriod start = domain.getStartPeriod().plus((long)(-nbcast));
        return TsDomain.of((TsPeriod)start, (int)nbcast);
    }

    default public TsData op(TsData l, TsData ... r) {
        if (this.getDescription().isLogTransformation()) {
            return TsData.multiply((TsData)l, (TsData[])r);
        }
        return TsData.add((TsData)l, (TsData[])r);
    }

    default public TsData inv_op(TsData l, TsData r) {
        if (this.getDescription().isLogTransformation()) {
            return TsData.divide((TsData)l, (TsData)r);
        }
        return TsData.subtract((TsData)l, (TsData)r);
    }

    public static interface Description<M> {
        public TsData getSeries();

        default public TsDomain getDomain() {
            return this.getSeries().getDomain();
        }

        public boolean isLogTransformation();

        public LengthOfPeriodType getLengthOfPeriodTransformation();

        public Variable[] getVariables();

        public M getStochasticComponent();
    }

    public static interface Estimation {
        public TsDomain getDomain();

        public DoubleSeq getY();

        default public DoubleSeq originalY() {
            DoubleSeq y = this.getY();
            if (y.anyMatch(z -> Double.isNaN(z))) {
                return y;
            }
            MissingValueEstimation[] missing = this.getMissing();
            if (missing.length == 0) {
                return y;
            }
            double[] z2 = y.toArray();
            for (int i = 0; i < missing.length; ++i) {
                z2[missing[i].getPosition()] = Double.NaN;
            }
            return DoubleSeq.of((double[])z2);
        }

        public Matrix getX();

        public DoubleSeq getCoefficients();

        public Matrix getCoefficientsCovariance();

        public MissingValueEstimation[] getMissing();

        public ParametersEstimation getParameters();

        public LikelihoodStatistics getStatistics();

        public List<ProcessingLog.Information> getLogs();
    }
}

