/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import java.time.LocalDateTime;
import jdplus.toolkit.base.api.timeseries.regression.AdditiveOutlier;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.RationalBackFilter;
import jdplus.toolkit.base.core.modelling.regression.IOutlierFactory;

public class AdditiveOutlierFactory
implements IOutlierFactory {
    public static final AdditiveOutlierFactory FACTORY = new AdditiveOutlierFactory();

    private AdditiveOutlierFactory() {
    }

    public AdditiveOutlier make(LocalDateTime position) {
        return new AdditiveOutlier(position);
    }

    @Override
    public void fill(int outlierPosition, DataBlock buffer) {
        buffer.set(outlierPosition, 1.0);
    }

    @Override
    public IOutlierFactory.FilterRepresentation getFilterRepresentation() {
        return new IOutlierFactory.FilterRepresentation(new RationalBackFilter(BackFilter.ONE, BackFilter.ONE, 0), 0.0);
    }

    @Override
    public int excludingZoneAtStart() {
        return 0;
    }

    @Override
    public int excludingZoneAtEnd() {
        return 0;
    }

    @Override
    public String getCode() {
        return "AO";
    }
}

