/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima;

import java.util.List;
import java.util.function.Function;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.regarima.RegArimaMapping;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.estimation.ConcentratedLikelihoodComputer;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodStatistics;
import jdplus.toolkit.base.core.stats.likelihood.LogLikelihoodFunction;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class RegArimaEstimation<M extends IArimaModel> {
    @NonNull
    private final RegArimaModel<M> model;
    @NonNull
    private final ConcentratedLikelihoodWithMissing concentratedLikelihood;
    private final LogLikelihoodFunction.Point<RegArimaModel<M>, ConcentratedLikelihoodWithMissing> max;
    private final double llAdjustment;

    public int parametersCount() {
        return this.max == null ? 0 : this.max.getParameters().length();
    }

    public LikelihoodStatistics statistics() {
        return LikelihoodStatistics.statistics(this.concentratedLikelihood.logLikelihood(), this.model.getObservationsCount() - this.model.getMissingValuesCount()).llAdjustment(this.llAdjustment).differencingOrder(this.model.arima().getNonStationaryArOrder()).parametersCount(this.parametersCount() + this.model.getVariablesCount() + 1).ssq(this.concentratedLikelihood.ssq()).build();
    }

    public static <M extends IArimaModel> LogLikelihoodFunction<RegArimaModel<SarimaModel>, ConcentratedLikelihoodWithMissing> concentratedLogLikelihoodFunction(IArimaMapping<M> mapping, RegArimaModel<M> regs) {
        RegArimaMapping<M> rmapping = new RegArimaMapping<M>(mapping, regs);
        Function<RegArimaModel, ConcentratedLikelihoodWithMissing> fn = model -> ConcentratedLikelihoodComputer.DEFAULT_COMPUTER.compute(model);
        return new LogLikelihoodFunction<RegArimaModel<SarimaModel>, ConcentratedLikelihoodWithMissing>(rmapping, fn);
    }

    public static <M extends IArimaModel> RegArimaEstimation<M> of(RegArimaModel<M> model, int nparams) {
        ConcentratedLikelihoodWithMissing ll = ConcentratedLikelihoodComputer.DEFAULT_COMPUTER.compute(model);
        return RegArimaEstimation.builder().model(model).concentratedLikelihood(ll).max(null).build();
    }

    public static <M extends IArimaModel> RegArimaEstimation<M> of(RegArimaModel<M> model, double llcorr, int nparams) {
        ConcentratedLikelihoodWithMissing ll = ConcentratedLikelihoodComputer.DEFAULT_COMPUTER.compute(model);
        return RegArimaEstimation.builder().model(model).concentratedLikelihood(ll).llAdjustment(llcorr).max(null).build();
    }

    public DoubleSeq interpolatedSeries() {
        DoubleSeq y = this.model.getY();
        int[] missing = this.model.missing();
        if (missing.length == 0) {
            return y;
        }
        double[] ay = y.toArray();
        DoubleSeq missingEstimates = this.concentratedLikelihood.missingCorrections();
        DoubleSeqCursor reader = missingEstimates.cursor();
        for (int i = 0; i < missing.length; ++i) {
            ay[missing[i]] = reader.getAndNext();
        }
        return DoubleSeq.of((double[])ay);
    }

    public DoubleSeq linearizedSeries() {
        DoubleSeq y = this.interpolatedSeries();
        List<DoubleSeq> x = this.model.getX();
        if (x.isEmpty()) {
            return y;
        }
        DoubleSeq coefficients = this.concentratedLikelihood.coefficients();
        DoubleSeqCursor reader = coefficients.cursor();
        DataBlock ylin = DataBlock.of(y);
        if (this.model.isMean()) {
            reader.getAndNext();
        }
        for (DoubleSeq cur : x) {
            ylin.addAY(-reader.getAndNext(), DataBlock.of(cur));
        }
        return ylin.unmodifiable();
    }

    @Generated
    RegArimaEstimation(@NonNull RegArimaModel<M> model, @NonNull ConcentratedLikelihoodWithMissing concentratedLikelihood, LogLikelihoodFunction.Point<RegArimaModel<M>, ConcentratedLikelihoodWithMissing> max, double llAdjustment) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (concentratedLikelihood == null) {
            throw new NullPointerException("concentratedLikelihood is marked non-null but is null");
        }
        this.model = model;
        this.concentratedLikelihood = concentratedLikelihood;
        this.max = max;
        this.llAdjustment = llAdjustment;
    }

    @Generated
    public static <M extends IArimaModel> @org.jspecify.annotations.NonNull Builder<M> builder() {
        return new Builder();
    }

    @NonNull
    @Generated
    public RegArimaModel<M> getModel() {
        return this.model;
    }

    @NonNull
    @Generated
    public ConcentratedLikelihoodWithMissing getConcentratedLikelihood() {
        return this.concentratedLikelihood;
    }

    @Generated
    public LogLikelihoodFunction.Point<RegArimaModel<M>, ConcentratedLikelihoodWithMissing> getMax() {
        return this.max;
    }

    @Generated
    public double getLlAdjustment() {
        return this.llAdjustment;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegArimaEstimation)) {
            return false;
        }
        RegArimaEstimation other = (RegArimaEstimation)o;
        if (Double.compare(this.getLlAdjustment(), other.getLlAdjustment()) != 0) {
            return false;
        }
        RegArimaModel<M> this$model = this.getModel();
        RegArimaModel<M> other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        ConcentratedLikelihoodWithMissing this$concentratedLikelihood = this.getConcentratedLikelihood();
        ConcentratedLikelihoodWithMissing other$concentratedLikelihood = other.getConcentratedLikelihood();
        if (this$concentratedLikelihood == null ? other$concentratedLikelihood != null : !this$concentratedLikelihood.equals(other$concentratedLikelihood)) {
            return false;
        }
        LogLikelihoodFunction.Point<RegArimaModel<M>, ConcentratedLikelihoodWithMissing> this$max = this.getMax();
        LogLikelihoodFunction.Point<RegArimaModel<M>, ConcentratedLikelihoodWithMissing> other$max = other.getMax();
        return !(this$max == null ? other$max != null : !((Object)this$max).equals(other$max));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $llAdjustment = Double.doubleToLongBits(this.getLlAdjustment());
        result = result * 59 + (int)($llAdjustment >>> 32 ^ $llAdjustment);
        RegArimaModel<M> $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        ConcentratedLikelihoodWithMissing $concentratedLikelihood = this.getConcentratedLikelihood();
        result = result * 59 + ($concentratedLikelihood == null ? 43 : $concentratedLikelihood.hashCode());
        LogLikelihoodFunction.Point<RegArimaModel<M>, ConcentratedLikelihoodWithMissing> $max = this.getMax();
        result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "RegArimaEstimation(model=" + String.valueOf(this.getModel()) + ", concentratedLikelihood=" + String.valueOf(this.getConcentratedLikelihood()) + ", max=" + String.valueOf(this.getMax()) + ", llAdjustment=" + this.getLlAdjustment() + ")";
    }

    @Generated
    public static class Builder<M extends IArimaModel> {
        @Generated
        private RegArimaModel<M> model;
        @Generated
        private ConcentratedLikelihoodWithMissing concentratedLikelihood;
        @Generated
        private LogLikelihoodFunction.Point<RegArimaModel<M>, ConcentratedLikelihoodWithMissing> max;
        @Generated
        private double llAdjustment;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder<M> model(@NonNull RegArimaModel<M> model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder<M> concentratedLikelihood(@NonNull ConcentratedLikelihoodWithMissing concentratedLikelihood) {
            if (concentratedLikelihood == null) {
                throw new NullPointerException("concentratedLikelihood is marked non-null but is null");
            }
            this.concentratedLikelihood = concentratedLikelihood;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder<M> max(LogLikelihoodFunction.Point<RegArimaModel<M>, ConcentratedLikelihoodWithMissing> max) {
            this.max = max;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder<M> llAdjustment(double llAdjustment) {
            this.llAdjustment = llAdjustment;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull RegArimaEstimation<M> build() {
            return new RegArimaEstimation<M>(this.model, this.concentratedLikelihood, this.max, this.llAdjustment);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "RegArimaEstimation.Builder(model=" + String.valueOf(this.model) + ", concentratedLikelihood=" + String.valueOf(this.concentratedLikelihood) + ", max=" + String.valueOf(this.max) + ", llAdjustment=" + this.llAdjustment + ")";
        }
    }
}

