/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.array;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.ISsfState;

public class LState {
    public final DataBlock a;
    public final FastMatrix L;

    public LState(FastMatrix L) {
        this.a = DataBlock.make(L.getRowsCount());
        this.L = L;
    }

    public static LState of(ISsfState ssf) {
        FastMatrix L = FastMatrix.square(ssf.getStateDim());
        ssf.initialization().Pf0(L);
        SymmetricMatrix.lcholesky(L, 1.0E-9);
        LowerTriangularMatrix.toLower(L);
        LState state = new LState(L);
        ssf.initialization().a0(state.a);
        return state;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("mean:\r\n").append(this.a).append("\r\n");
        builder.append("Cholesky factor of the covariance:\r\n").append(this.L);
        return builder.toString();
    }
}

