/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.basic;

import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.data.DataWindow;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.QuadraticForm;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.Ssf;
import lombok.Generated;

public final class RegSsf {
    public static Ssf ssf(ISsf model, FastMatrix X) {
        if (X.isEmpty()) {
            throw new IllegalArgumentException();
        }
        int mdim = model.getStateDim();
        int nx = X.getColumnsCount();
        return Ssf.of((ISsfInitialization)new Xinitializer(model.initialization(), nx), (ISsfDynamics)new Xdynamics(mdim, model.dynamics(), nx), (ISsfLoading)new Xloading(mdim, model.loading(), X), model.measurementError());
    }

    public static Ssf timeVaryingSsf(ISsf model, FastMatrix X, FastMatrix cvar) {
        int nx = X.getColumnsCount();
        if (X.isEmpty() || !cvar.isSquare() || cvar.getColumnsCount() != nx) {
            throw new IllegalArgumentException();
        }
        int mdim = model.getStateDim();
        FastMatrix s = cvar.deepClone();
        SymmetricMatrix.lcholesky(s, 1.0E-12);
        return Ssf.of((ISsfInitialization)new Xinitializer(model.initialization(), nx), (ISsfDynamics)new Xvardynamics(mdim, model.dynamics(), cvar, s), (ISsfLoading)new Xloading(mdim, model.loading(), X), model.measurementError());
    }

    public static ISsfLoading defaultLoading(int dim, ISsfLoading loading, FastMatrix X) {
        return new Xloading(dim, loading, X);
    }

    public static StateComponent of(StateComponent cmp, FastMatrix X) {
        if (X.isEmpty()) {
            throw new IllegalArgumentException();
        }
        int mdim = cmp.dim();
        int nx = X.getColumnsCount();
        return new StateComponent(new Xinitializer(cmp.initialization(), nx), new Xdynamics(mdim, cmp.dynamics(), nx));
    }

    public static StateComponent ofTimeVarying(StateComponent cmp, FastMatrix X, FastMatrix cvar) {
        int nx = X.getColumnsCount();
        if (X.isEmpty() || !cvar.isSquare() || cvar.getColumnsCount() != nx) {
            throw new IllegalArgumentException();
        }
        int mdim = cmp.dim();
        FastMatrix s = cvar.deepClone();
        SymmetricMatrix.lcholesky(s, 1.0E-12);
        return new StateComponent(new Xinitializer(cmp.initialization(), nx), new Xvardynamics(mdim, cmp.dynamics(), cvar, s));
    }

    public static StateComponent ofTimeVaryingFactor(StateComponent cmp, FastMatrix X, FastMatrix l) {
        int nx = X.getColumnsCount();
        if (X.isEmpty() || !l.isSquare() || l.getColumnsCount() != nx) {
            throw new IllegalArgumentException();
        }
        int mdim = cmp.dim();
        return new StateComponent(new Xinitializer(cmp.initialization(), nx), new Xvardynamics(mdim, cmp.dynamics(), SymmetricMatrix.XXt(l), l));
    }

    @Generated
    private RegSsf() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class Xinitializer
    implements ISsfInitialization {
        private final int n;
        private final int nx;
        private final ISsfInitialization dyn;

        Xinitializer(ISsfInitialization init, int nx) {
            this.dyn = init;
            this.n = init.getStateDim();
            this.nx = nx;
        }

        @Override
        public int getStateDim() {
            return this.n + this.nx;
        }

        @Override
        public boolean isDiffuse() {
            return true;
        }

        @Override
        public int getDiffuseDim() {
            return this.nx + this.dyn.getDiffuseDim();
        }

        @Override
        public void diffuseConstraints(FastMatrix b) {
            int nd = this.dyn.getDiffuseDim();
            if (nd > 0) {
                this.dyn.diffuseConstraints(b.extract(0, this.n, 0, nd));
            }
            b.subDiagonal(nd - this.n).drop(nd, 0).set(1.0);
        }

        @Override
        public void a0(DataBlock a0) {
            this.dyn.a0(a0.range(0, this.n));
        }

        @Override
        public void Pf0(FastMatrix pf0) {
            this.dyn.Pf0(pf0.extract(0, this.n, 0, this.n));
        }

        @Override
        public void Pi0(FastMatrix pi0) {
            this.dyn.Pi0(pi0.extract(0, this.n, 0, this.n));
            pi0.diagonal().drop(this.n, 0).set(1.0);
        }
    }

    static class Xdynamics
    implements ISsfDynamics {
        private final int n;
        private final int nx;
        private final ISsfDynamics dyn;

        Xdynamics(int n, ISsfDynamics dyn, int nx) {
            this.dyn = dyn;
            this.n = n;
            this.nx = nx;
        }

        @Override
        public int getInnovationsDim() {
            return this.dyn.getInnovationsDim();
        }

        @Override
        public void V(int pos, FastMatrix qm) {
            this.dyn.V(pos, qm.extract(0, this.n, 0, this.n));
        }

        @Override
        public void S(int pos, FastMatrix cm) {
            this.dyn.S(pos, cm.extract(0, this.n, 0, cm.getColumnsCount()));
        }

        @Override
        public boolean hasInnovations(int pos) {
            return this.dyn.hasInnovations(pos);
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return this.dyn.areInnovationsTimeInvariant();
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            this.dyn.T(pos, tr.extract(0, this.n, 0, this.n));
            tr.diagonal().drop(this.n, 0).set(1.0);
        }

        @Override
        public void TX(int pos, DataBlock x) {
            this.dyn.TX(pos, x.range(0, this.n));
        }

        @Override
        public void TM(int pos, FastMatrix m) {
            this.dyn.TM(pos, m.extract(0, this.n, 0, m.getColumnsCount()));
        }

        @Override
        public void TVT(int pos, FastMatrix m) {
            FastMatrix dz = m.extract(0, this.n, 0, this.n);
            this.dyn.TVT(pos, dz);
            FastMatrix hz = m.extract(0, this.n, this.n, this.nx);
            this.dyn.TM(pos, hz);
            FastMatrix cz = m.extract(this.n, this.nx, 0, this.n);
            cz.copyTranspose(hz);
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void XT(int pos, DataBlock x) {
            this.dyn.XT(pos, x.range(0, this.n));
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            this.dyn.addV(pos, p.extract(0, this.n, 0, this.n));
        }

        @Override
        public boolean isTimeInvariant() {
            return this.dyn.isTimeInvariant();
        }
    }

    static class Xloading
    implements ISsfLoading {
        private final ISsfLoading loading;
        private final FastMatrix data;
        private final int n;
        private final int nx;
        private final DataBlock tmp;

        private Xloading(int n, ISsfLoading loading, FastMatrix data) {
            this.data = data;
            this.loading = loading;
            this.n = n;
            this.nx = data.getColumnsCount();
            this.tmp = DataBlock.make(this.nx);
        }

        private FastMatrix v00(FastMatrix v) {
            return v.extract(0, this.n, 0, this.n);
        }

        private FastMatrix r0(FastMatrix m) {
            return m.extract(0, this.n, 0, m.getColumnsCount());
        }

        private FastMatrix r1(FastMatrix m) {
            return m.extract(this.n, this.nx, 0, m.getColumnsCount());
        }

        private FastMatrix v11(FastMatrix v) {
            return v.extract(this.n, this.nx, this.n, this.nx);
        }

        private FastMatrix v01(FastMatrix v) {
            return v.extract(0, this.n, this.n, this.nx);
        }

        private FastMatrix v10(FastMatrix v) {
            return v.extract(this.n, this.nx, 0, this.n);
        }

        @Override
        public boolean isTimeInvariant() {
            return false;
        }

        @Override
        public void Z(int pos, DataBlock z) {
            DataWindow range = z.window(0, this.n);
            this.loading.Z(pos, range.get());
            range.next(this.nx).copy(this.data.row(pos));
        }

        @Override
        public double ZX(int pos, DataBlock x) {
            DataWindow range = x.window(0, this.n);
            double r = this.loading.ZX(pos, range.get());
            return r + range.next(this.nx).dot(this.data.row(pos));
        }

        @Override
        public double ZVZ(int pos, FastMatrix V) {
            double v00 = this.loading.ZVZ(pos, this.v00(V));
            this.tmp.set(0.0);
            this.loading.ZM(pos, this.v01(V), this.tmp);
            double v01 = this.tmp.dot(this.data.row(pos));
            double v11 = QuadraticForm.apply(this.v11(V), this.data.row(pos));
            return v00 + 2.0 * v01 + v11;
        }

        @Override
        public void VpZdZ(int pos, FastMatrix V, double d) {
            if (d == 0.0) {
                return;
            }
            this.loading.VpZdZ(pos, this.v00(V), d);
            FastMatrix v01 = this.v01(V);
            FastMatrix v10 = this.v10(V);
            FastMatrix v11 = this.v11(V);
            DataBlockIterator cols = v01.columnsIterator();
            DataBlock xrow = this.data.row(pos);
            DoubleSeqCursor.OnMutable x = xrow.cursor();
            while (cols.hasNext()) {
                this.loading.XpZd(pos, cols.next(), d * x.getAndNext());
            }
            v10.copyTranspose(v01);
            v11.addXaXt(d, xrow);
        }

        @Override
        public void XpZd(int pos, DataBlock x, double d) {
            DataWindow range = x.left();
            this.loading.XpZd(pos, range.next(this.n), d);
            range.next(this.nx).addAY(d, this.data.row(pos));
        }
    }

    static class Xvardynamics
    implements ISsfDynamics {
        private final int n;
        private final int nx;
        private final ISsfDynamics dyn;
        private final FastMatrix var;
        private final FastMatrix s;

        private FastMatrix v00(FastMatrix v) {
            return v.extract(0, this.n, 0, this.n);
        }

        private FastMatrix r0(FastMatrix m) {
            return m.extract(0, this.n, 0, m.getColumnsCount());
        }

        private FastMatrix r1(FastMatrix m) {
            return m.extract(this.n, this.nx, 0, m.getColumnsCount());
        }

        private FastMatrix v11(FastMatrix v) {
            return v.extract(this.n, this.nx, this.n, this.nx);
        }

        private FastMatrix v01(FastMatrix v) {
            return v.extract(0, this.n, this.n, this.nx);
        }

        private FastMatrix v10(FastMatrix v) {
            return v.extract(this.n, this.nx, 0, this.n);
        }

        Xvardynamics(int n, ISsfDynamics dyn, FastMatrix xvar, FastMatrix xs) {
            this.dyn = dyn;
            this.n = n;
            this.nx = xvar.getColumnsCount();
            this.var = xvar;
            this.s = xs;
        }

        @Override
        public int getInnovationsDim() {
            return this.dyn.getInnovationsDim() + this.s.getColumnsCount();
        }

        @Override
        public void V(int pos, FastMatrix qm) {
            this.dyn.V(pos, this.v00(qm));
            this.v11(qm).copy(this.var);
        }

        @Override
        public void S(int pos, FastMatrix cm) {
            int m = this.dyn.getInnovationsDim();
            this.dyn.S(pos, cm.extract(0, this.n, 0, m));
            cm.extract(this.n, this.nx, m, this.s.getColumnsCount()).copy(this.s);
        }

        @Override
        public boolean hasInnovations(int pos) {
            return true;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return this.dyn.areInnovationsTimeInvariant();
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            this.dyn.T(pos, tr.extract(0, this.n, 0, this.n));
            tr.diagonal().drop(this.n, 0).set(1.0);
        }

        @Override
        public void TX(int pos, DataBlock x) {
            this.dyn.TX(pos, x.range(0, this.n));
        }

        @Override
        public void TM(int pos, FastMatrix m) {
            this.dyn.TM(pos, this.r0(m));
        }

        @Override
        public void TVT(int pos, FastMatrix m) {
            this.dyn.TVT(pos, this.v00(m));
            FastMatrix v01 = this.v01(m);
            this.dyn.TM(pos, v01);
            this.v10(m).copyTranspose(v01);
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            DataWindow xleft = x.left();
            DataWindow xsleft = xs.left();
            this.dyn.XS(pos, xleft.next(this.n), xsleft.next(this.dyn.getInnovationsDim()));
            xsleft.next(this.s.getColumnsCount()).product(xleft.next(this.nx), this.s.columnsIterator());
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void XT(int pos, DataBlock x) {
            this.dyn.XT(pos, x.range(0, this.n));
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            this.dyn.addV(pos, this.v00(p));
            this.v11(p).add(this.var);
        }

        @Override
        public boolean isTimeInvariant() {
            return this.dyn.isTimeInvariant();
        }
    }
}

