/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.math.distributions.TDistribution;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class MultivariateTDiffusionModel
extends MultivariateDiffusionModel {
    public static final String DIFFUSION_PROCESS = "multivariateTDiffusionModel";
    public static final String DIFFUSION_CONSTANT = "precisionParameter";
    public static final String DF = "dfParameter";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("precisionParameter", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("dfParameter", new XMLSyntaxRule[]{new ElementRule(Parameter.class)})};

        @Override
        public String getParserName() {
            return MultivariateTDiffusionModel.DIFFUSION_PROCESS;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            XMLObject xMLObject2 = xMLObject.getChild(MultivariateTDiffusionModel.DIFFUSION_CONSTANT);
            MatrixParameterInterface matrixParameterInterface = (MatrixParameterInterface)xMLObject2.getChild(MatrixParameterInterface.class);
            xMLObject2 = xMLObject.getChild(MultivariateTDiffusionModel.DF);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            return new MultivariateTDiffusionModel(parameter, matrixParameterInterface);
        }

        @Override
        public String getParserDescription() {
            return "Describes a multivariate t-distribution diffusion process.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return MultivariateTDiffusionModel.class;
        }
    };
    private final Parameter dfParameter;
    private final MatrixParameterInterface precisionParameter;

    public MultivariateTDiffusionModel(Parameter parameter, MatrixParameterInterface matrixParameterInterface) {
        this.dfParameter = parameter;
        this.precisionParameter = matrixParameterInterface;
        this.addVariable(this.dfParameter);
        this.addVariable(this.precisionParameter);
    }

    @Override
    public double getLogLikelihood(double[] dArray, double[] dArray2, double d) {
        double d2 = this.dfParameter.getParameterValue(0);
        double d3 = this.precisionParameter.getParameterValue(0);
        double d4 = this.precisionParameter.getParameterValue(1);
        return TDistribution.logPDF(dArray2[0], dArray[0], d / d3, d2) + TDistribution.logPDF(dArray2[1], dArray[1], d / d4, d2);
    }

    @Override
    public MatrixParameterInterface getPrecisionParameter() {
        return this.precisionParameter;
    }

    @Override
    protected void calculatePrecisionInfo() {
    }
}

