/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.GammaDistribution;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExponentialMarkovModel
extends AbstractModelLikelihood {
    public static final String EXPONENTIAL_MARKOV_MODEL = "exponentialMarkovLikelihood";
    private String id = null;
    private Parameter chainParameter = null;
    private boolean jeffreys = false;
    private boolean reverse = false;
    private double shape = 1.0;

    public ExponentialMarkovModel(Parameter parameter, boolean bl, boolean bl2, double d) {
        super(EXPONENTIAL_MARKOV_MODEL);
        this.chainParameter = parameter;
        this.jeffreys = bl;
        this.reverse = bl2;
        this.shape = d;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter.getDimension()));
    }

    public Parameter getChainParameter() {
        return (Parameter)this.getVariable(0);
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public Model getModel() {
        return this;
    }

    private int index(int n) {
        if (this.reverse) {
            return this.chainParameter.getDimension() - n - 1;
        }
        return n;
    }

    @Override
    public double getLogLikelihood() {
        double d = 0.0;
        if (this.jeffreys) {
            d += -Math.log(this.chainParameter.getParameterValue(this.index(0)));
        }
        for (int i = 1; i < this.chainParameter.getDimension(); ++i) {
            double d2 = this.chainParameter.getParameterValue(this.index(i - 1));
            double d3 = this.chainParameter.getParameterValue(this.index(i));
            double d4 = d2 / this.shape;
            d += GammaDistribution.logPdf(d3, this.shape, d4);
        }
        return d;
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

