/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.inference.model.GradientProvider;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;
import dr.math.distributions.NormalDistribution;

public class LogNormalDistribution
implements Distribution,
GradientProvider {
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return LogNormalDistribution.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return 0.0;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    protected double M;
    protected double S;

    public LogNormalDistribution(double d, double d2) {
        this.M = d;
        this.S = d2;
    }

    public final double getM() {
        return this.M;
    }

    public final void setM(double d) {
        this.M = d;
    }

    public final double getS() {
        return this.S;
    }

    public final void setS(double d) {
        this.S = d;
    }

    @Override
    public double pdf(double d) {
        return LogNormalDistribution.pdf(d, this.M, this.S);
    }

    @Override
    public double logPdf(double d) {
        return LogNormalDistribution.logPdf(d, this.M, this.S);
    }

    @Override
    public double cdf(double d) {
        return LogNormalDistribution.cdf(d, this.M, this.S);
    }

    @Override
    public double quantile(double d) {
        return LogNormalDistribution.quantile(d, this.M, this.S);
    }

    @Override
    public double mean() {
        return LogNormalDistribution.mean(this.M, this.S);
    }

    @Override
    public double variance() {
        return LogNormalDistribution.variance(this.M, this.S);
    }

    public double mode() {
        return LogNormalDistribution.mode(this.M, this.S);
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    public static double pdf(double d, double d2, double d3) {
        if (d <= 0.0) {
            return 0.0;
        }
        return NormalDistribution.pdf(Math.log(d), d2, d3) / d;
    }

    public static double logPdf(double d, double d2, double d3) {
        if (d < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return NormalDistribution.logPdf(Math.log(d), d2, d3) - Math.log(d);
    }

    public static double cdf(double d, double d2, double d3) {
        if (d < 0.0) {
            return 0.0;
        }
        return NormalDistribution.cdf(Math.log(d), d2, d3, false);
    }

    public static double quantile(double d, double d2, double d3) {
        return Math.exp(NormalDistribution.quantile(d, d2, d3));
    }

    public static double mean(double d, double d2) {
        return Math.exp(d + d2 * d2 / 2.0);
    }

    public static double mode(double d, double d2) {
        return Math.exp(d - d2 * d2);
    }

    public static double variance(double d, double d2) {
        double d3 = d2 * d2;
        return Math.exp(d3 + 2.0 * d) * (Math.exp(d3) - 1.0);
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        double[] dArray = GradientProvider.toDoubleArray(object);
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = (NormalDistribution.gradLogPdf(Math.log(dArray[i]), this.M, this.S) - 1.0) / dArray[i];
        }
        return dArray2;
    }
}

