## ----echo=FALSE---------------------------------------------------------------

library(inteq)

# Define the kernel function
k <- function(s, t) {
    ifelse(abs(s - t) <= 3, 1 + cos(pi * (t - s) / 3), 0)
}

# Define the right-hand side function
f <- function(s) {
    sp <- abs(s)
    sp3 <- sp * pi / 3
    ((6 - sp) * (2 + cos(sp3)) + (9 / pi) * sin(sp3)) / 2
}

# Define the true solution for comparison
trueg <- function(s) {
    k(0, s)
}

# Solve the Fredholm equation
res <- fredholm_solve(
    k, f, -3, 3, 1001L,
    smin = -6, smax = 6, snum = 2001L,
    gamma = 0.01
)

# Plot the results on the same graph using base graphics
plot(
    res$ygrid, res$ggrid,
    type = "l",
    col = "blue",
    xlim = c(-3, 3),
    #ylim = c(-1, 1),
    xlab = "s",
    ylab = "g(s)",
    main = "Fredholm Equation Solution"
)
# add the true solution
lines(res$ygrid, trueg(res$ygrid), col = "red", lty = 2)
legend( 
    "topright",
    legend = c("Estimated Value", "True Value"),
    col = c("blue", "red"),
    lty = c(1, 2)
)

#end of code chunk

## ----echo=FALSE---------------------------------------------------------------
k <- function(s,t) {
        cos(t-s)
}
trueg <- function(s) {
    (2+s**2)/2
}

res <- volterra_solve(k,a=0,b=1,num=1000)

plot(
    res$sgrid, res$ggrid,
    type = "l",
    col = "blue",
    xlim = c(0, 1),
    #ylim = c(-1, 1),
    xlab = "s",
    ylab = "g(s)",
    main = "Volterra Equation Solution first kind"
)
# add the true solution
lines(res$sgrid, trueg(res$sgrid), col = "red", lty = 2)
legend( 
    "topright",
    legend = c("Estimated Value", "True Value"),
    col = c("blue", "red"),
    lty = c(1, 2)
)


## ----echo=FALSE---------------------------------------------------------------
k <- function(s,t) {
        0.5 * (t-s)** 2 * exp(t-s)
}
free <- function(t) {
    0.5 * t**2 * exp(-t)
}
true <- function(t) {
    1/3 * (1 - exp(-3*t/2) * (cos(sqrt(3)/2*t) + sqrt(3) * sin(sqrt(3)/2*t)))
}

res <- volterra_solve2(k,free,a=0,b=6,num=100)

plot(
    res$sgrid, res$ggrid,
    type = "l",
    col = "blue",
    xlim = c(0, 6),
    #ylim = c(-1, 1),
    xlab = "s",
    ylab = "g(s)",
    main = "Volterra Equation Solution second kind"
)
# add the true solution
lines(res$sgrid, true(res$sgrid), col = "red", lty = 2)
legend( 
    "topright",
    legend = c("Estimated Value", "True Value"),
    col = c("blue", "red"),
    lty = c(1, 2)
)


