/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.util;

import java.io.File;
import java.util.StringTokenizer;
import org.rosuda.util.GlobalConfig;

public class RecentList {
    String appName;
    String recentKey;
    int maxEntries;
    int active;
    int serial;
    public boolean autoSave = true;
    String[] list;

    public RecentList(String string, String string2, int n) {
        if (n < 1) {
            n = 8;
        }
        this.maxEntries = n;
        this.recentKey = string2;
        this.appName = string != null ? string : "default";
        this.list = new String[n];
        this.active = 0;
        this.loadFromGlobalConfig();
    }

    public void reset() {
        this.active = 0;
        int n = 0;
        while (n < this.maxEntries) {
            this.list[n++] = null;
        }
        ++this.serial;
        if (this.autoSave) {
            this.saveToGlobalConfig();
        }
    }

    public void addEntry(String string) {
        if (string == null || string.length() < 1) {
            return;
        }
        for (int i = 0; i < this.active; ++i) {
            if (!this.list[i].equals(string)) continue;
            if (i > 0) {
                String string2 = this.list[i];
                for (int j = i; j > 0; --j) {
                    this.list[j] = this.list[j - 1];
                }
                this.list[0] = string2;
                ++this.serial;
                if (this.autoSave) {
                    this.saveToGlobalConfig();
                }
            }
            return;
        }
        if (this.active >= this.maxEntries) {
            for (int i = this.maxEntries - 1; i > 0; --i) {
                this.list[i] = this.list[i - 1];
            }
            this.list[0] = string;
        } else {
            if (this.active > 0) {
                for (int i = this.active; i > 0; --i) {
                    this.list[i] = this.list[i - 1];
                }
            }
            this.list[0] = string;
            ++this.active;
        }
        ++this.serial;
        if (this.autoSave) {
            this.saveToGlobalConfig();
        }
    }

    public int count() {
        return this.active;
    }

    public int getSerial() {
        return this.serial;
    }

    void loadFromGlobalConfig() {
        if (this.recentKey == null) {
            return;
        }
        boolean bl = this.autoSave;
        this.autoSave = false;
        GlobalConfig globalConfig = GlobalConfig.getGlobalConfig();
        String string = globalConfig.getParS("app." + this.appName + "." + this.recentKey);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            this.active = 0;
            while (this.active < this.maxEntries && stringTokenizer.hasMoreTokens()) {
                this.list[this.active] = stringTokenizer.nextToken();
                ++this.active;
            }
        }
        this.autoSave = bl;
        ++this.serial;
    }

    void saveToGlobalConfig() {
        if (this.recentKey == null) {
            return;
        }
        GlobalConfig globalConfig = GlobalConfig.getGlobalConfig();
        String string = null;
        for (int i = 0; i < this.active; ++i) {
            string = string == null ? this.list[i] : string + "\t" + this.list[i];
        }
        globalConfig.setParS("app." + this.appName + "." + this.recentKey, string == null ? "" : string);
    }

    public String[] getAllEntries() {
        return this.list;
    }

    public String[] getShortEntries() {
        int n;
        String string;
        int n2;
        String[] stringArray = new String[this.active];
        for (n2 = 0; n2 < this.active; ++n2) {
            string = this.list[n2];
            n = string.lastIndexOf(File.separatorChar);
            if (n > 0) {
                string = string.substring(n + 1);
            }
            stringArray[n2] = string;
        }
        for (n2 = 0; n2 < this.active; ++n2) {
            string = stringArray[n2];
            boolean bl = false;
            for (n = 0; n < this.active; ++n) {
                if (n2 == n || stringArray[n].compareTo(string) != 0) continue;
                bl = true;
                stringArray[n] = this.list[n];
            }
            if (!bl) continue;
            stringArray[n2] = this.list[n2];
        }
        return stringArray;
    }
}

